// @ts-ignore
/* eslint-disable */
import { request } from 'umi';
import { graphql } from '@/services/common';

/**
 * 工序未通过率基准分页查询
 * @param params
 * @param options?
 */
export async function pageQuery(
  params: KANBAN.Settings.ProcessDefectRatioDatumPageCriteria,
  options?: { [p: string]: any },
) {
  const specification: string[] = [];
  if (params.werks && params.werks.length > 0) {
    specification.push(`werks: {_v: like,_val: "%${params.werks}%"}`);
  }
  if (params.fevor && params.fevor.length > 0) {
    specification.push(`fevor: {_v: like,_val: "%${params.fevor}%"}`);
  }
  if (params.stepCode && params.stepCode.length > 0) {
    specification.push(`stepCode: {_v: eq,_val: "${params.stepCode}"}`);
  }
  if (params.operationName && params.operationName.length > 0) {
    specification.push(`operationName: {_v: like,_val: "${params.operationName}%"}`);
  }
  if (params.datumDate) {
    specification.push(`datumDate: {_v: eq,_val: "${params.datumDate}-01 00:00:00"}`);
  }
  const query = `{${specification.join(',')}}`;
  const gqlString = `query{
            processDefectRatioDatumPage(
              pageable:{
                page:${params.current - 1},
                size:${params.pageSize},
                sort:{
                    orders:[
                    {
                      pty:"werks",
                      dir:asc
                    },
                    {
                      pty:"fevor",
                      dir:asc
                    }]
                  }
                },
              specification:${query}){
                totalPages,
                totalElements,
                content{
                  id,
                  stepCode,
                  operationName,
                  werks,
                  fevor,
                  datumDate,
                  datumValue,
                }
              }
          }`;
  const graphqlParams: Common.GraphqlParams = {
    operationName: null,
    variables: null,
    query: gqlString,
  };
  const result = await graphql(graphqlParams, options);
  const pageResult: Common.PageResult<KANBAN.Settings.ProcessDefectRatioDatumDto> = {
    current: params.current,
    pageSize: params.pageSize,
    total: result.data.processDefectRatioDatumPage.totalElements,
    data: result.data.processDefectRatioDatumPage.content,
  };
  return pageResult;
}

/**
 * 工序未通过率基准创建
 * @param body
 * @param options
 */
export async function create(
  body: KANBAN.Settings.ProcessDefectRatioDatumCreate,
  options?: { [key: string]: any },
) {
  return request<Common.ServiceResult<string>>('/processDefectRatioDatum/create', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

/**
 * 工序未通过率基准更新
 * @param body
 * @param options
 */
export async function update(
  body: KANBAN.Settings.ProcessDefectRatioDatumUpdate,
  options?: { [key: string]: any },
) {
  return request<Common.ServiceResult<string>>('/processDefectRatioDatum/update', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

/**
 * 工序未通过率基准删除
 * @param body
 * @param options
 */
export async function remove(body: Common.RemoveDto, options?: { [key: string]: any }) {
  return request<Common.ServiceResult<string>>(`/api/processDefectRatioDatum/remove`, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}
