import { queryHFChangedInfoDataDto } from '@/pages/kanban/weldingProcessKanban/services/api';
import ProTable, { ActionType } from '@ant-design/pro-table';
import { useEffect, useRef } from 'react';

const OrderModalTable: React.FC<{ params: any }> = ({ params }) => {
  const actionRef = useRef<ActionType>();
  useEffect(() => {
    actionRef.current?.reload();
  }, [params]);

  const columns = [
    {
      title: '批号',
      dataIndex: 'lotNo',
      key: 'lotNo',
      width: 100,
    },
    {
      title: '生产订单',
      dataIndex: 'aufnr',
      key: 'aufnr',
      width: 100,
    },
    {
      title: '工厂',
      dataIndex: 'werks',
      key: 'werks',
      width: 60,
    },
    {
      title: '生产管理员',
      dataIndex: 'fevor',
      key: 'fevor',
      width: 60,
    },
    {
      title: '焊缝类型',
      dataIndex: 'hfType',
      key: 'hfType',
      width: 110,
    },
    {
      title: '底片编号',
      dataIndex: 'plateNo',
      key: 'plateNo',
      width: 110,
    },
    {
      title: '变更片数',
      dataIndex: 'changedPicQuantity',
      key: 'changedPicQuantity',
      width: 70,
    },
    {
      title: '变更数量',
      dataIndex: 'changedQuantity',
      key: 'changedQuantity',
      width: 70,
    },
    {
      title: '返修原因',
      dataIndex: 'repairCause',
      key: 'repairCause',
      width: 100,
    },
    {
      title: '创建日期',
      dataIndex: 'createdDate',
      key: 'createdDate',
      width: 110,
    },
  ];

  return (
    <>
      <ProTable
        options={false}
        search={false}
        actionRef={actionRef}
        pagination={false}
        request={async (pms: any) => {
          const sr = await queryHFChangedInfoDataDto({ ...params });
          return {
            data: sr.data,
            success: true,
          };
        }}
        columns={columns}
        size={'middle'}
        bordered
        scroll={{ x: 1100 }}
      />
    </>
  );
};

export default OrderModalTable;
