import type { PieConfig } from '@ant-design/charts';
import { Pie } from '@ant-design/plots';
import React, { useEffect, useState } from 'react';

const Main: React.FC<{ data: number }> = ({ data }) => {
  const [chartData, setChartData] = useState<PieConfig['data']>([]);
  useEffect(() => {
    const res = [];
    res.push({ type: '按片未通过率', value: 100 - data });
    res.push({ type: '按片通过率', value: data });
    setChartData(res);
  }, [data]);
  const config: PieConfig & React.RefAttributes<unknown> = {
    data: chartData,
    width: 100,
    color: ['#213045', '#28a8c3'],
    angleField: 'value',
    colorField: 'type',
    radius: 1,
    innerRadius: 0.6,
    yAxis: false,
    xAxis: false,
    legend: false,
    label: false,
    pieStyle: {
      stroke: null,
    },
    statistic: {
      title: false,
      content: {
        content: data + '%',
        style: {
          fontSize: '14px',
          color: '#fff',
        },
      },
    },
    tooltip: false,
  };
  return <Pie {...config} />;
};

export default Main;
