import React, { useEffect, useRef, useState } from 'react';
import './index.less';
import PartModalTable from './modal';
import { Modal } from 'antd';

type PartProgressDetailSetting = KANBAN.MaterialSynthesis.PartProgressDetailSetting;
type PartProgressDetailCriteria = KANBAN.MaterialSynthesis.PartProgressDetailCriteria;
type PartScheduleIndexDataDto = KANBAN.MaterialSynthesis.PartScheduleIndexDataDto;

const Main: React.FC<{ data: PartScheduleIndexDataDto[]; setting: PartProgressDetailSetting }> = ({
  data,
  setting,
}) => {
  const [nums, setNums] = useState({ total: 0, unfinish: 0 });
  useEffect(() => {
    setNums(
      data.reduce(
        (pre, cur) => {
          pre.total += cur.totalQuantity;
          pre.unfinish += cur.unFinishQuantity;
          return pre;
        },
        { total: 0, unfinish: 0 },
      ),
    );
  }, [data]);

  const [isModalOpen, setIsModalOpen] = useState(false);
  const closeModal = () => setIsModalOpen(false);
  const [criteria, setCriteria] = useState<PartProgressDetailCriteria>();
  const openModal = (wkname) => {
    setIsModalOpen(true);
    setCriteria({
      fevor: setting.conf
        .filter((s) => s.workShop == wkname)
        .map((s) => s.fevor)
        .join(','),
      werks: setting.werks,
      pageSize: 10,
      current: 1,
    });
  };

  return (
    <>
      <div className="partProgress-container">
        <div className="title">
          <h2>零部件进度</h2>
          <div className="num">
            <span>总数量：{nums.total}</span>
            <span>未完成：{nums.unfinish}</span>
          </div>
        </div>
        <div className="table-container">
          <div className="table-header">
            <div className="item">车间</div>
            <div className="item">总数量</div>
            <div className="item">未完成数量</div>
          </div>
          <div className="table-body">
            {data?.map((item, index) => {
              return (
                <div className="row" key={index}>
                  <div className="item">{item.workshopName}</div>
                  <div className="item">{item.totalQuantity}</div>
                  <div
                    className="item"
                    onClick={() => {
                      openModal(item.workshopName);
                    }}
                  >
                    {item.unFinishQuantity}
                  </div>
                </div>
              );
            })}
          </div>
        </div>
      </div>
      <Modal
        title={'零部件进度'}
        visible={isModalOpen}
        footer={null}
        width={'70%'}
        onCancel={closeModal}
      >
        <PartModalTable values={criteria} />
      </Modal>
    </>
  );
};

export default Main;
