import { request } from 'umi';
export type SettingDto = KANBAN.EvacuationProcessKanban.Setting;
type ReqWrokUnit = {
  standardDays: number;
  beyondDays: number;
  processConfs: [];
  workUnitConfs: [];
};

export async function queryCKKanbanSetting() {
  return request<Api.ServiceResult<SettingDto[]>>('/chouKongProcessKanbanSetting/list', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
  });
}

export async function queryWorkUnitIndex(data: ReqWrokUnit) {
  return request<Api.ServiceResult<KANBAN.EvacuationProcessKanban.WorkUnit[]>>(
    '/api/chouKongProcessData/statisWorkUnitIndex',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data,
    },
  );
}

export async function queryStatisIndex(data: ReqWrokUnit) {
  return request<Api.ServiceResult<KANBAN.EvacuationProcessKanban.StatisIndexDto>>(
    '/api/chouKongProcessData/statisIndex',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data,
    },
  );
}

// 当月日度
export async function queryQuantityByMonth(data: ReqWrokUnit) {
  return request<Api.ServiceResult<KANBAN.EvacuationProcessKanban.chartDto[]>>(
    '/api/chouKongProcessData/statisQuantityByMonthDay',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data,
    },
  );
}
// 当年月度
export async function queryQuantityByYearMonth(data: ReqWrokUnit) {
  return request<Api.ServiceResult<KANBAN.EvacuationProcessKanban.chartDto[]>>(
    '/api/chouKongProcessData/statisQuantityByYearMonth',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data,
    },
  );
}
// 当月日度 （平均时长）
export async function queryDurationByDMonthDay(data: ReqWrokUnit) {
  return request<Api.ServiceResult<KANBAN.EvacuationProcessKanban.chartDto[]>>(
    '/api/chouKongProcessData/statisCycleDurationByMonthDay',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data,
    },
  );
}
// 当年月度 （平均时长）
export async function queryDurationByDYearMonth(data: ReqWrokUnit) {
  return request<Api.ServiceResult<KANBAN.EvacuationProcessKanban.chartDto[]>>(
    '/api/chouKongProcessData/statisCycleDurationByYearMonth',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data,
    },
  );
}

export async function queryPenetratingBatchInfo(
  data: { workUnitName: string } & Common.PageParams,
) {
  return request<Api.ServiceResult<KANBAN.EvacuationProcessKanban.PenetratingBatchInfoDto[]>>(
    '/api/chouKongProcessData/findPenetratingBatchInfo',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data,
    },
  );
}
