import { queryProductionErrorDetail } from '@/pages/kanban/productionComprehens/services/api';
import ProTable, { ActionType } from '@ant-design/pro-table';
import React, { useEffect, useRef } from 'react';

type ErrorDetailCriteria = KANBAN.ProductionComprehens.ErrorDetailCriteria;

export type InfoProps = {
  values: ErrorDetailCriteria;
};

const ProductAbnormalTable: React.FC<InfoProps> = (props) => {
  const actionRef = useRef<ActionType>();
  useEffect(() => {
    actionRef.current?.reload();
  }, [props.values]);
  const columns = [
    {
      title: '单号',
      dataIndex: 'productionExceptionNo',
      key: 'productionExceptionNo',
      width: 120,
    },
    {
      title: '状态',
      dataIndex: 'stateName',
      key: 'stateName',
      width: 120,
    },
    {
      title: '异常所在工序',
      dataIndex: 'ycszgx',
      key: 'ycszgx',
      width: 120,
    },
    {
      title: '异常发生时间',
      dataIndex: 'ycfxsj',
      key: 'ycfxsj',
      width: 120,
    },
    {
      title: 'SAP生产订单号',
      dataIndex: 'scddh',
      key: 'scddh',
      width: 120,
    },
    {
      title: '产品编号',
      dataIndex: 'cpbh',
      key: 'cpbh',
      width: 120,
    },
    {
      title: '异常问题类型',
      dataIndex: 'ycwtlx',
      key: 'ycwtlx',
      width: 120,
    },
    {
      title: '责任部门',
      dataIndex: 'zrbm',
      key: 'zrbm',
      width: 120,
    },
    {
      title: '责任部门描述',
      dataIndex: 'zrbm_des',
      key: 'zrbm_des',
      width: 120,
    },
    {
      title: '异常问题延误情况描述',
      dataIndex: 'ycwtywqkms',
      key: 'ycwtywqkms',
      width: 140,
    },
    {
      title: '车间应急措施',
      dataIndex: 'cjyjcs',
      key: 'cjyjcs',
      width: 120,
    },
    {
      title: 'BPM流程ID',
      dataIndex: 'requestid',
      key: 'requestid',
      width: 120,
    },
    {
      title: '异常原因',
      dataIndex: 'ex_reason',
      key: 'ex_reason',
      width: 120,
    },
    {
      title: '异常措施',
      dataIndex: 'ex_method',
      key: 'ex_method',
      width: 120,
    },
    {
      title: '标识',
      dataIndex: 'msgty',
      key: 'msgty',
      width: 120,
    },
    {
      title: '消息',
      dataIndex: 'message',
      key: 'message',
      width: 120,
    },
    {
      title: '创建人',
      dataIndex: 'createdByName',
      key: 'createdByName',
      width: 120,
    },
    {
      title: '创建时间',
      dataIndex: 'createdDate',
      key: 'createdDate',
      width: 120,
    },
    {
      title: '提交时间',
      dataIndex: 'submittedDate',
      key: 'submittedDate',
      width: 120,
    },
    {
      title: '取消时间',
      dataIndex: 'cancelledDate',
      key: 'cancelledDate',
      width: 120,
    },
    {
      title: '处理时间',
      dataIndex: 'executedDate',
      key: 'executedDate',
      width: 120,
    },
  ];

  return (
    <>
      <ProTable
        options={false}
        search={false}
        actionRef={actionRef}
        request={async (params: ErrorDetailCriteria) => {
          const sr = await queryProductionErrorDetail({
            ...props.values,
            pageSize: params.pageSize,
            current: params.current,
          });
          const pageResult: Common.PageResult<any> = {
            current: params.current,
            pageSize: params.pageSize,
            total: sr.data.total,
            data: sr.data.data,
          };
          return pageResult;
        }}
        pagination={{
          pageSize: 10,
        }}
        columns={columns}
        size={'middle'}
        bordered
        scroll={{ x: 3000 }}
      />
    </>
  );
};

export default ProductAbnormalTable;
