import React, { useState, useEffect, useMemo, useCallback } from 'react';
import { NodeGroup } from 'react-move';
import { interpolate, interpolateTransformSvg } from 'd3-interpolate';
import styles from './index.less';
import StepCell from '../StepCell';
import { Modal } from 'antd';
import ProductionDetail from './productionDetail';
import ProductionAbnormal from './productionAbnormal';
import moment from 'moment';

type ErrorDetailCriteria = KANBAN.ProductionComprehens.ErrorDetailCriteria;
type ProductionProgressKanbanData = KANBAN.ProductionProgress.ProductionProgressKanbanDataDto;
type ProductionProgressKanbanSetting = KANBAN.ProductionProgress.ProductionProgressKanbanSetting;

type ProgressTableProps = {
  lineName: string;
  data: ProductionProgressKanbanData[];
  conditionKey: string;
  rowMovingTime: number;
};

const ProgressTable: React.FC<ProgressTableProps> = ({
  lineName,
  data,
  conditionKey,
  rowMovingTime,
}) => {
  data = {
    "taskPlanDayList": [
      {
        "productList": [
          {
            "itemCode": "",
            "planQuantity": "",
            "processList": [
              {
                "processName": "",
                "qualifiedRate": 0,
                "qualifyQuantity": 0,
                "reportQuantity": 0
              }
            ]
          }
        ],
        "startDate": ""
      }
    ]
  }
  const rowHight = 60;
  const displayCount = 13;

  const [displayData, setDisplayData] = useState<ProductionProgressKanbanData[]>([]);
  const [displayAt, setDisplayAt] = useState(0);
  const [lastConditionKey, setLastConditionKey] = useState('');
  const [pause, setPause] = useState(false);
  const [scollOnce, setScollOnce] = useState(false);

  const updateDisplayData = (da: number, sData: ProductionProgressKanbanData[]) => {
    let endAt1 = da + displayCount;
    let endAt2 = 0;
    if (endAt1 > sData.length) {
      endAt2 = endAt1 - sData.length;
      endAt1 = sData.length;
    }
    const ret = sData.slice(da, endAt1);
    if (sData.length > displayCount) {
      sData.slice(0, endAt2).forEach((i) => ret.push(i));
    }
    setDisplayData(ret);
  };

  useEffect(() => {
    if (lastConditionKey !== conditionKey) {
      setLastConditionKey(conditionKey);
      setDisplayAt(0);
      updateDisplayData(0, data);
    }
  }, [conditionKey, lastConditionKey, data]);

  const scoll = useCallback(() => {
    if (pause) {
      return;
    }
    let da = 0;
    if (data.length > displayCount) {
      da = displayAt + 1;
      if (da >= data.length) {
        da = 0;
      }
    }
    setDisplayAt(da);
    updateDisplayData(da, data);
  }, [data, displayAt, pause]);

  useEffect(() => {
    const t = setInterval(() => {
      scoll();
    }, rowMovingTime * 1000);
    return () => {
      clearTimeout(t);
    };
  }, [rowMovingTime, scoll]);

  const [criteria, setCriteria] = useState({} as ErrorDetailCriteria);
  const [productionDetailParams, setProductionDetailParams] = useState({
    kanbanSettingId: '',
    aufnr: '',
    processName: '',
  });



  useEffect(() => {
    if (scollOnce) {
      scoll();
      setScollOnce(false);
    }
  }, [scollOnce, scoll]);

  return (
    <div className={styles.main}>
      <div className={styles.row_container} style={{ height: rowHight }}>
        <div className={styles.row_segment1}>
          <div
            className={`${styles.row_segment1_section1} ${styles.no_top_border} ${styles.no_left_border}`}
          >
            <div className={styles.cell}>日期</div>
          </div>
          <div className={`${styles.row_segment1_section2} ${styles.no_top_border}`}>
            <div className={styles.cell}>产品</div>
          </div>
          <div className={`${styles.row_segment1_section2} ${styles.no_top_border}`}>
            <div className={styles.cell}>计划数</div>
          </div>
          <div className={`${styles.row_segment1_section2} ${styles.no_top_border} ${styles.no_right_border}`}>
            <div className={styles.cell}>工序</div>
          </div>
        </div>
      </div>
      <NodeGroup
        data={displayData}
        keyAccessor={(d) => d.aufnr}
        start={(d, i) => {
          return { y: i * rowHight, opacity: 0 };
        }}
        enter={() => {
          return { opacity: [1], timing: { duration: 1000 } };
        }}
        update={(d, i) => {
          return { y: [i * rowHight], opacity: [1], timing: { duration: 1000 } };
        }}
        leave={() => {
          return { y: [-rowHight], opacity: [0], timing: { duration: 1000 } };
        }}
        interpolation={(begValue, endValue, attr) => {
          if (attr === 'transform') {
            return interpolateTransformSvg(begValue, endValue);
          }
          return interpolate(begValue, endValue);
        }}
      >
        {(nodes) => (
          <div
            className={styles.data_rowcontent}
            onMouseEnter={() => setPause(true)}
            onMouseLeave={() => {
              setPause(false);
              setScollOnce(true);
            }}
          >
            {nodes.map((node: { [key: string]: any; data: ProductionProgressKanbanData }) => (
              <div
                className={styles.row_container}
                key={node.key}
                style={{
                  position: 'absolute',
                  left: 0,
                  top: 0,
                  width: '100%',
                  height: rowHight,
                  transform: `translate(0px, ${node.state.y}px)`,
                  opacity: node.state.opacity,
                }}
              >
                {/* <div className={styles.row_segment1}>
                  <div
                    className={styles.row_segment1_section1}
                  >
                    <div className={styles.cell}>{node.data[lineName.sgNoSourceType.code]}</div>
                  </div>
                  <div className={styles.row_segment1_section2}>
                    <div className={styles.cell}>{node.data.planQuantity}</div>
                  </div>
                </div>
                <div className={styles.row_segment2}>
                  {lineName.progress.steps.map((step) => (
                    <div
                      className={styles.row_section}
                      style={{ width: row_segment2_section_width }}
                      key={step.code}
                    >
                      <StepCell step={step} data={node.data} lineName={lineName} />
                    </div>
                  ))}
                </div> */}
              </div>
            ))}
          </div>
        )}
      </NodeGroup>
    </div>
  );
};

export default ProgressTable;
