// @ts-ignore
/* eslint-disable */
import { request } from 'umi';
import { graphql } from '@/services/common';

/**
 * 设备总数量查询
 * @param params
 * @param options?
 */
export async function query(
  params: Report.Settings.DeviceTotalQuantityCriteria,
  options?: { [p: string]: any },
) {
  const specification: string[] = [];
  if (params.id && params.id.length > 0) {
    specification.push(`id: {_v: eq,_val: ${params.id}}`);
  }
  const query = `{${specification.join(',')}}`;
  const gqlString = `query{
            deviceTotalQuantity(
              specification:${query},
              sort:{
                orders:[
                {
                  pty:"workshop",
                  dir:asc
                }]
              }){
                id,
                workshop,
                quantity,
              }
          }`;
  const graphqlParams: Common.GraphqlParams = {
    operationName: null,
    variables: null,
    query: gqlString,
  };
  const result = await graphql(graphqlParams, options);
  return result.data.deviceTotalQuantity as Report.Settings.DeviceTotalQuantityDto[];
}

/**
 * 设备总数量分页查询
 * @param params
 * @param options?
 */
export async function pageQuery(
  params: Report.Settings.DeviceTotalQuantityPageCriteria,
  options?: { [p: string]: any },
) {
  return request<Api.ServiceResult<Api.PageResult<Report.Settings.DeviceTotalQuantityDto>>>(
    '/api/deviceTotalQuantity/page',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: params,
      ...(options || {}),
    },
  );
}

/**
 * 设备总数量创建
 * @param body
 * @param options
 */
export async function create(
  body: Report.Settings.DeviceTotalQuantityCreate,
  options?: { [key: string]: any },
) {
  return request<Common.ServiceResult<string>>('/deviceTotalQuantity/create', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

/**
 * 设备总数量更新
 * @param body
 * @param options
 */
export async function update(
  body: Report.Settings.DeviceTotalQuantityUpdate,
  options?: { [key: string]: any },
) {
  return request<Common.ServiceResult<string>>('/deviceTotalQuantity/update', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

/**
 * 设备总数量删除
 * @param body
 * @param options
 */
export async function remove(body: Common.RemoveDto, options?: { [key: string]: any }) {
  return request<Common.ServiceResult<string>>(`/api/deviceTotalQuantity/remove`, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}
