import React, { useRef } from 'react';
import type { ProFormInstance } from '@ant-design/pro-form';
import { DrawerForm } from '@ant-design/pro-form';
import { List } from 'antd';

export type LotFormProps = {
  values: Partial<any>;
  visible: boolean;
  onVisibleChange: (visible: boolean) => void;
};

const LotForm: React.FC<LotFormProps> = (props) => {
  const formRef = useRef<ProFormInstance>();

  return (
    <DrawerForm
      formRef={formRef}
      title="批次"
      width={600}
      visible={props.visible}
      onVisibleChange={(visible: boolean) => {
        if (visible) {
          formRef?.current?.setFieldsValue({
            ...props.values,
          });
        }
        props.onVisibleChange(visible);
      }}
      submitter={false}
    >
      <List
        bordered
        dataSource={props.values?.sgNos}
        renderItem={(item: string) => <List.Item>{item}</List.Item>}
      />
    </DrawerForm>
  );
};

export default LotForm;
