import React, { useEffect, useRef } from 'react';
import styles from './index.less';
const CommonCustTable: React.FC<{
  data: KANBAN.WeldingProcessKanban.DataListDto[];
  setting: any;
}> = ({ data, setting }) => {
  const deviceRef = useRef<HTMLDivElement>(null);
  const intervalTimer = useRef();
  const timeoutTimer = useRef();
  const autoScrollDevice = () => {
    if (timeoutTimer.current) {
      clearInterval(timeoutTimer.current);
    }
    timeoutTimer.current = setTimeout(() => {
      const scrollH = deviceRef.current?.scrollHeight || 0;
      const clientH = deviceRef.current?.clientHeight || 0;
      if (intervalTimer.current) {
        clearInterval(intervalTimer.current);
      }
      if (scrollH == clientH) return;
      intervalTimer.current = setInterval(() => {
        if (deviceRef.current) {
          const scrollTop = deviceRef.current.scrollTop;
          const distance = scrollH - clientH;
          if (scrollTop >= distance) {
            deviceRef.current.scrollTop = 0;
            clearInterval(intervalTimer.current);
            autoScrollDevice();
            return;
          }
          deviceRef.current.scrollTop = scrollTop + 40;
        }
      }, setting.rowMovingTime * 1000);
    }, 0);
  };
  useEffect(() => {
    if (deviceRef.current) {
      deviceRef.current.scrollTop = 0;
      clearInterval(timeoutTimer.current);
      clearInterval(intervalTimer.current);
      autoScrollDevice();
    }
  }, [data]);

  return (
    <div className="table-container">
      <div className="table-header">
        <div className="item">施工号</div>
        <div className="item">委托时间</div>
        <div className="item">检测时间</div>
        <div className="item">检测结果</div>
        <div className="item">最终结果</div>
        {/*<div className="item">返修结果</div>*/}
      </div>
      <div className="table-body over_style" ref={deviceRef}>
        {data.map((item) => {
          return (
            <div
              className={
                item.status == '合格' || item.backDate
                  ? styles.cell_backgroud_green
                  : styles.cell_backgroud_red
              }
            >
              <div className="row" key={item.sgNo}>
                <div className="item">{item.sgNo}</div>
                <div className="item">{item.trustDate}</div>
                <div className="item">{item.testDate}</div>
                <div className="item">{item.status}</div>
                <div className="item">{item.backDate}</div>
                {/*<div className="item">{item.resultStatus}</div>*/}
              </div>
            </div>
          );
        })}
      </div>
    </div>
  );
};

export const YuanZhao: React.FC<{
  data: KANBAN.WeldingProcessKanban.DataListDto[];
  setting: any;
}> = ({ data, setting }) => {
  return (
    <div className="common-card-container">
      <div className="title">原照</div>
      <CommonCustTable data={data} setting={setting} />
    </div>
  );
};

export const HeLongFeng: React.FC<{
  data: KANBAN.WeldingProcessKanban.DataListDto[];
  setting: any;
}> = ({ data, setting }) => {
  return (
    <div className="common-card-container">
      <div className="title">合拢缝</div>
      <CommonCustTable data={data} setting={setting} />
    </div>
  );
};
