import { request } from 'umi';
import { graphql } from '@/services/common';

type ProcessFailQualityErrorDto = KANBAN.ProductionComprehens.ProcessFailQualityErrorDto;
type MaterialReqOrderInfoDto = KANBAN.ProductionComprehens.MaterialReqOrderInfoDto;
type MaterialReqOrderInfoCriteria = KANBAN.ProductionComprehens.MaterialReqOrderInfoCriteria;
type EquipmentDetailCriteria = KANBAN.ProductionComprehens.EquipmentDetailCriteria;
type EquipmentDetailDto = KANBAN.ProductionComprehens.EquipmentDetailDto;
type EquipmentErrorDetailDto = KANBAN.ProductionComprehens.EquipmentErrorDetailDto;
type ProductionErrorDetailDto = KANBAN.ProductionComprehens.ProductionErrorDetailDto;
type AbnormalOverdueSettingDto = KANBAN.ProductionComprehens.AbnormalOverdueSettingDto;
type ErrorDetailCriteria = KANBAN.ProductionComprehens.ErrorDetailCriteria;
type QualityDetailDto = KANBAN.ProductionComprehens.QualityDetailDto;
type ProductionComprehensKanbanDataDto =
  KANBAN.ProductionComprehens.ProductionComprehensKanbanDataDto;
type ProcessYieldData = KANBAN.ProductionComprehens.ProcessYieldData;
type ProcessDefectRatioData = KANBAN.ProductionComprehens.ProcessDefectRatioData;
type WorkOrderMonthlyIndexData = KANBAN.ProductionComprehens.WorkOrderMonthlyIndexData;
type ComprehensiveDeviceEcpDataCount = KANBAN.ProductionComprehens.ComprehensiveDeviceEcpDataCount;
type ComprehensiveDataCount = KANBAN.ProductionComprehens.ComprehensiveDataCount;
type CountWeldingPassRate = KANBAN.ProductionComprehens.CountWeldingPassRate;
type PassRateTrendChart = KANBAN.ProductionComprehens.PassRateTrendChart;
type BatchInfoDto = KANBAN.ProductionComprehens.BatchInfoDto;

type ProcessOutputParams = {
  kanbanSettingId: string;
  planSource: number;
  dataRange: number;
};
type ChartData = {
  period: string;
  val: number;
};

export async function queryProductionComprehensKanbanData() {
  return request<Api.ServiceResult<ProductionComprehensKanbanDataDto[]>>(
    '/md/workunit/selectGroupLineName',
    {
      method: 'GET',
      headers: {
        'Content-Type': 'application/json',
      },
    },
  );
}

export async function queryEquipmentCurrentMonthStat(body: ProcessOutputParams) {
  return request<Api.ServiceResult<ProcessYieldData[]>>('/kanban/equipment/currentMonthStat', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
  });
}

// 质量异常
export async function currentMonthStat(body: { settingId: string }) {
  return request<Api.ServiceResult<ComprehensiveDataCount>>(
    '/kanban/abnormal/currentMonthStat',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      params: body,
    },
  );
}
// 焊接通过率趋势图
export async function queryCountWeldingPassRateTrendChart(data: { kanbanSettingId: string }) {
  return request<Api.ServiceResult<PassRateTrendChart[]>>(
    '/api/batchInfo/countWeldingPassRateTrendChart',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data,
    },
  );
}
// 工序一次未通过率趋势图
export async function queryPunctualityPenetratingByKanban(data: {
  kanbanSettingId: string;
  processName: string;
}) {
  return request<Api.ServiceResult<PassRateTrendChart[]>>(
    '/api/processDefectRatioData/punctualityPenetratingByKanban',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data,
    },
  );
}
// 工序一次未通过关联质量异常
export async function queryProcessFailQualityError(data: {
  kanbanSettingId: string;
  processName: string;
}) {
  return request<Api.ServiceResult<ProcessFailQualityErrorDto[]>>(
    '/api/processDefectRatioData/listQualityError',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data,
    },
  );
}

// 质量异常明细
export async function queryQualityDetail(body: ErrorDetailCriteria) {
  return request<Api.ServiceResult<Api.PageResult<QualityDetailDto>>>(
    '/api/Kanban/GetExceptionInfo',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
    },
  );
}

// 设备异常明细
export async function queryEquipmentErrorDetail(body: ErrorDetailCriteria) {
  return request<Api.ServiceResult<Api.PageResult<EquipmentErrorDetailDto>>>(
    '/api/Kanban/GetDEInfo',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
    },
  );
}

// 生产异常明细
export async function queryProductionErrorDetail(body: ErrorDetailCriteria) {
  return request<Api.ServiceResult<Api.PageResult<ProductionErrorDetailDto>>>(
    '/api/Kanban/GetPEInfo',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
    },
  );
}

// 设备详情
export async function queryEquipmentDetail(body: EquipmentDetailCriteria) {
  return request<Api.ServiceResult<Api.PageResult<EquipmentDetailDto>>>(
    '/api/Kanban/GetDeviceInfo',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
    },
  );
}

// 领料单
export async function queryMaterialReqOrderInfo(body: MaterialReqOrderInfoCriteria) {
  return request<Api.ServiceResult<Api.PageResult<MaterialReqOrderInfoDto>>>(
    '/api/Kanban/GetMaterialReqOrderInfo',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
    },
  );
}

// 获取全局配置异常超期天数
export async function findAbnormalOverdueSetting(options?: { [p: string]: any }) {
  const specification: string[] = [];
  const query = `{${specification.join(',')}}`;
  const gqlString = `query{
            abnormalOverdueSetting(
              specification:${query},
              sort:{
                orders:[]
              }){
                werks,
                type{
                  id,name
                },
                overdueDays,
              }
            }`;
  const graphqlParams: Common.GraphqlParams = {
    operationName: null,
    variables: null,
    query: gqlString,
  };
  const result = await graphql(graphqlParams, options);
  return result.data.abnormalOverdueSetting as AbnormalOverdueSettingDto[];
}

// 领料单
export async function queryProcesspunctualityPenetrating(body) {
  return request<Api.ServiceResult<Api.PageResult<{ lotNos: string; currentProcessName: string }>>>(
    '/api/processYieldData1/punctualityPenetratingByKanban',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
    },
  );
}

// 工单明细
export async function queryPageByKanbanPenetrating(
  body: { kanbanSettingId: string; type: number; boardType?: number } & Common.PageParams,
) {
  return request<Api.ServiceResult<Api.PageResult<BatchInfoDto[]>>>(
    '/api/batchInfo/pageByKanbanPenetrating',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
    },
  );
}

// 工单趋势数据
export async function queryBatchInfoPunctualityPenetrating(body: {
  kanbanSettingId: string;
  type: number;
}) {
  return request<Api.ServiceResult<Api.PageResult<{ period: string; val: number }[]>>>(
    '/api/batchInfo/punctualityPenetratingByKanban',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
    },
  );
}
// 工单年度计划量
export async function queryPlanQuantityPenetratingByKanban(body: { kanbanSettingId: string }) {
  return request<Api.ServiceResult<{ period: string; val: number }[]>>(
    '/api/batchInfo/planQuantityPenetratingByKanban',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
    },
  );
}

export async function queryMonthPlanRateData(body: { settingId: string }) {
  return request<
    Api.ServiceResult<{ currentMonthRate: ChartData[]; beforeMonthRate: ChartData[] }>
  >('/workOrderMonthlyIndexData/statisticMonthPlanIndexAllYear', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    params: body,
  });
}
