import FactoryItem from './FactoryItem';
import { useEffect, useRef } from 'react';
import styles from '../../index.less';
type ErrorDetailSetting = KANBAN.ProductionComprehens.ErrorDetailSetting;

const Abnormal: React.FC<{
  abnormalProdData: any;
  abnormalQualityData: any;
  abnormalDeviceData: any;
  factoryLine: Array<any>;
  setting: ErrorDetailSetting;
}> = ({ abnormalProdData, abnormalQualityData, abnormalDeviceData, factoryLine, setting, }) => {
  const leftScroll = useRef<HTMLDivElement>(null);
  let timer: NodeJS.Timer | null = null;
  const stopLoop = () => {
    if (timer) {
      clearInterval(timer);
      timer = null;
    }
  };
  const startLoop = () => {
    stopLoop();
    if (leftScroll && leftScroll.current && (leftScroll.current.scrollTop || leftScroll.current.scrollTop === 0)) {
      timer = setInterval(() => {
        if(!leftScroll || !leftScroll.current) return
        let scrollTop = leftScroll.current.scrollTop
        if (scrollTop + 60 + leftScroll.current.offsetHeight >= leftScroll.current.scrollHeight) {
          leftScroll.current.scrollTo({
            top: 0, 
            behavior: 'instant',
          });
        } else {
          leftScroll.current.scrollTop += 60
        }
      }, setting.rowMovingTime * 1000)
    }
  };
  
  useEffect(() => {
    stopLoop()
    startLoop()
    return () => {
      stopLoop()
    }
  }, [setting]);
  return (
    <>
      <div className={styles.leftWrapper} ref={leftScroll} onMouseOver={stopLoop}//移出关闭
      onMouseOut={startLoop}>
        {factoryLine.map((factory) => (
          <div className={styles.Factorycard} >
            <div>{factory.name}</div>
            <div className={styles.itemContainer} >
              <FactoryItem data={factory.arr} setting={setting} />
            </div>
          </div>
        ))}
      </div>
    </>
  );
};

export default Abnormal;
