import type { LineConfig } from '@ant-design/charts';
import { Line } from '@ant-design/plots';
import './index.less';
// import * as echarts from 'echarts/lib/echarts';
import { useEffect, useRef, useState } from 'react';
// import { ECharts, getInstanceByDom } from 'echarts';
import { useIntl } from 'umi';

type MissProps = {
  month: KANBAN.MaterialSynthesis.CountCurrentMonthLackMaterialKanbanDto[];
  lack: KANBAN.MaterialSynthesis.CountCurrentLackMaterialKanbanDto[];
};

const MonthLine: React.FC<{ month: MissProps['month'] }> = ({ month }) => {
  const [data, setData] = useState([]);
  const countMax = () => {
    return Math.max(...data.map((item) => item.value)) * 1.2;
  };
  useEffect(() => {
    setData(
      month
        .sort((a, b) => a.day - b.day)
        .map((item) => {
          item.day += '';
          item['type'] = '数量'
          return item;
        }),
    );
  }, [month]);
  const config: LineConfig & React.RefAttributes<unknown> = {
    data,
    width: 946,
    height: 110,
    xField: 'day',
    yField: 'value',
    smooth: true,
    lineStyle: {
      stroke: '#1b46df',
      lineWidth: 4,
    },
    point: {
      size: 3,
      shape: 'square',
      style: {
        fill: 'white',
      },
    },
    xAxis: {
      line: null,
      tickLine: null,
      label: {
        style: {
          fill: '#fff',
        },
      },
    },
    label: {
      style: {
        fill: '#fff',
      },
    },
    seriesField: 'type',
    legend: { 
      position: 'right-top',
      style: {
        fill: '#fff',
      }
    },
    yAxis: {
      tickLine: null,
      line: null,
      grid: null,
      label: {
        style: {
          fill: '#fff',
        },
      },
      max: countMax(),
    },
    tooltip: false,
  };
  return <Line {...config} />;
};

const Main: React.FC<MissProps> = ({ month, lack }) => {
  const intl = useIntl();

  return (
    <div className="missingMaterial-container">
      <div className="title">
        <h2>{intl.formatMessage({id:'当月库存趋势图'})}</h2>
      </div>
      <div className="line-container1">
        <p>{intl.formatMessage({id:'当月生产入库趋势图'})}</p>
        <MonthLine month={month} />
      </div>
      <div className="line-container">
      <p>{intl.formatMessage({id:'当月发货出库趋势图'})}</p>
        <MonthLine month={lack} />
      </div>
    </div>
  );
};

export default Main;
