import './index.less';
import type { PieConfig } from '@ant-design/charts';
import { Pie } from '@ant-design/plots';
import * as echarts from 'echarts/lib/echarts';
import type { ECharts } from 'echarts';
import { getInstanceByDom } from 'echarts';
import { useEffect, useRef, useState } from 'react';
import { useIntl } from 'umi';

type EfficiencyKanbanSetting = KANBAN.MaterialSynthesis.EfficiencyKanbanSetting;

const PeiSongPie: React.FC<{ data: number; setting: EfficiencyKanbanSetting }> = ({
  data,
  setting,
}) => {
  const chartRef = useRef<HTMLDivElement>(null);
  useEffect(() => {
    // Initialize chart
    let chart: ECharts | undefined;
    if (chartRef.current !== null) {
      chart = echarts.init(chartRef.current);
    }

    // Add chart resize listener
    // ResizeObserver is leading to a bit janky UX
    function resizeChart() {
      chart?.resize();
    }
    window.addEventListener('resize', resizeChart);

    // Return cleanup function
    return () => {
      chart?.off('click');
      chart?.dispose();
      window.removeEventListener('resize', resizeChart);
    };
  }, []);
  useEffect(() => {
    if (chartRef.current !== null) {
      const chart = getInstanceByDom(chartRef.current);
      const option = {
        grid: {
          width: '100%',
        },
        color: ['#004af2', '#213045'],
        series: [
          {
            name: 'Access From',
            type: 'pie',
            radius: ['50%', '90%'],
            avoidLabelOverlap: false,
            label: {
              show: true,
              position: 'center',
              formatter: data + '%',
              color: '#fff',
              fontSize: '16px',
              fontWeight: 600,
            },
            silent: false,
            data: [
              { value: data, name: '物料配送完成率' },
              { value: 100 - data, name: '物料配送未完成率' },
            ],
          },
        ],
      };
      chart?.setOption(option);
    }
  }, [data]);
  return (
    <>
      <div ref={chartRef} style={{ height: '210px' }} />
    </>
  );
};

const ZhunshiPie: React.FC<{ data: number; setting: EfficiencyKanbanSetting }> = ({
  data,
  setting,
}) => {
  const chartRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    // Initialize chart
    let chart: ECharts | undefined;
    if (chartRef.current !== null) {
      chart = echarts.init(chartRef.current);
    }

    // Add chart resize listener
    // ResizeObserver is leading to a bit janky UX
    function resizeChart() {
      chart?.resize();
    }
    window.addEventListener('resize', resizeChart);

    // Return cleanup function
    return () => {
      chart?.off('click');
      chart?.dispose();
      window.removeEventListener('resize', resizeChart);
    };
  }, []);

  useEffect(() => {
    if (chartRef.current !== null) {
      const chart = getInstanceByDom(chartRef.current);
      const option = {
        grid: {
          width: '100%',
        },
        color: ['#004af2', '#213045'],
        series: [
          {
            name: 'Access From',
            type: 'pie',
            radius: ['50%', '90%'],
            avoidLabelOverlap: false,
            label: {
              show: true,
              position: 'center',
              formatter: data + '%',
              color: '#fff',
              fontSize: '16px',
              fontWeight: 600,
            },
            silent: false,
            data: [
              { value: data, name: '物料配送准时率' },
              { value: 100 - data, name: '不准时率' },
            ],
          },
        ],
      };
      chart?.setOption(option);
    }
  }, [data]);
  return (
    <>
      <div ref={chartRef} style={{ height: '210px' }} />
    </>
  );
};

const ShangxianPie: React.FC<{ data: number; setting: EfficiencyKanbanSetting }> = ({
  data,
  setting,
}) => {
  const chartRef = useRef<HTMLDivElement>(null);
  useEffect(() => {
    // Initialize chart
    let chart: ECharts | undefined;
    if (chartRef.current !== null) {
      chart = echarts.init(chartRef.current);
    }

    // Add chart resize listener
    // ResizeObserver is leading to a bit janky UX
    function resizeChart() {
      chart?.resize();
    }
    window.addEventListener('resize', resizeChart);

    // Return cleanup function
    return () => {
      chart?.off('click');
      chart?.dispose();
      window.removeEventListener('resize', resizeChart);
    };
  }, []);

  useEffect(() => {
    if (chartRef.current !== null) {
      const chart = getInstanceByDom(chartRef.current);
      const option = {
        grid: {
          width: '100%',
        },
        color: ['#249ab5', '#213045'],
        series: [
          {
            name: 'Access From',
            type: 'pie',
            radius: ['50%', '90%'],
            avoidLabelOverlap: false,
            label: {
              show: true,
              position: 'center',
              formatter: data + '%',
              color: '#fff',
              fontSize: '16px',
              fontWeight: 600,
            },
            silent: false,
            data: [
              { value: data, name: '订单上线准时率' },
              { value: 100 - data, name: '不准时率' },
            ],
          },
        ],
      };
      chart?.setOption(option);
    }
  }, [data]);
  return (
    <>
      <div ref={chartRef} style={{ height: '210px' }} />
    </>
  );
};

const XiaxianPie: React.FC<{ data: number; setting: EfficiencyKanbanSetting }> = ({
  data,
  setting,
}) => {
  const chartRef = useRef<HTMLDivElement>(null);
  useEffect(() => {
    // Initialize chart
    let chart: ECharts | undefined;
    if (chartRef.current !== null) {
      chart = echarts.init(chartRef.current);
    }

    // Add chart resize listener
    // ResizeObserver is leading to a bit janky UX
    function resizeChart() {
      chart?.resize();
    }
    window.addEventListener('resize', resizeChart);

    // Return cleanup function
    return () => {
      chart?.off('click');
      chart?.dispose();
      window.removeEventListener('resize', resizeChart);
    };
  }, []);
  useEffect(() => {
    if (chartRef.current !== null) {
      const chart = getInstanceByDom(chartRef.current);
      const option = {
        grid: {
          width: '100%',
        },
        color: ['#249ab5', '#213045'],
        series: [
          {
            name: 'Access From',
            type: 'pie',
            radius: ['50%', '90%'],
            avoidLabelOverlap: false,
            label: {
              show: true,
              position: 'center',
              formatter: data + '%',
              color: '#fff',
              fontSize: '16px',
              fontWeight: 600,
            },
            silent: false,
            data: [
              { value: data, name: '订单下线准时率' },
              { value: 100 - data, name: '不准时率' },
            ],
          },
        ],
      };
      chart?.setOption(option);
    }
  }, [data]);
  return (
    <>
      <div ref={chartRef} style={{ height: '210px' }} />
    </>
  );
};

const Main: React.FC<{ punctual: any; delivery: any; setting: EfficiencyKanbanSetting }> = ({
  punctual,
  delivery,
  setting,
}) => {
  const intl = useIntl();
  return (
    <div className="efficiency-container">
      <div className="row" style={{ marginBottom: '8px' }}>
        <div className="item" style={{ marginLeft: '0' }}>
          <h2>
            {intl.formatMessage({id: '物料配送完成率'})}
          </h2>
          <PeiSongPie data={delivery.stockInCompleteRatio} setting={setting} />
        </div>
        <div className="item">
          <h2>{intl.formatMessage({id: '生产入库完成率'})}</h2>
          <ZhunshiPie data={punctual} setting={setting} />
        </div>
      </div>
      <div className="row">
        <div className="item" style={{ marginLeft: '0' }}>
          <h2>{intl.formatMessage({id: '采购到货完成率'})}</h2>
          <ShangxianPie data={delivery.materialDistRatio} setting={setting} />
        </div>
        <div className="item">
          <h2>{intl.formatMessage({id: '销售发货及时率'})}</h2>
          <XiaxianPie data={delivery.salesTimelyDeliveryRatio} setting={setting} />
        </div>
      </div>
    </div>
  );
};

export default Main;
