import { Row } from 'antd';
import type { CSSProperties } from 'react';
import React from 'react';
import MachineCell from '../MachineCell';

type MachineRowProps = {
  machineStatusArray: MachineConnectivity.MachineStatus[];
  style: CSSProperties | undefined;
};

const MachineRow: React.FC<MachineRowProps> = ({ machineStatusArray, style }) => {
  return (
    <Row wrap={false} justify="space-around" align="middle" style={style}>
      {machineStatusArray.map((i) => (
        <MachineCell key={i.machineName} machineStatus={i} />
      ))}
    </Row>
  );
};

export default MachineRow;
