import React from 'react';
import type { PieConfig } from '@ant-design/plots';
import { Pie } from '@ant-design/plots';
import styles from './index.less';

type WorkTimeUnproductProps = {
  conditionKey: string;
};

const convertData = () => {
  const data: { type: string; value: number }[] = [];
  data.push({
    type: '培训',
    value: 54,
  });
  data.push({
    type: '会议',
    value: 32,
  });
  data.push({
    type: '活动',
    value: 14,
  });
  return data;
};

const WorkTimeUnproduct: React.FC<WorkTimeUnproductProps> = ({}) => {
  const config: PieConfig & React.RefAttributes<unknown> = {
    data: convertData(),
    angleField: 'value',
    colorField: 'type',
    radius: 0.7,
    innerRadius: 0.5,
    yAxis: false,
    xAxis: false,
    legend: {
      layout: 'vertical',
      position: 'right',
      itemName: {
        style: {
          fill: '#0ff',
          fontSize: 16,
        },
      },
      marker: (_name, _index, item) => {
        return {
          ...item,
          style: {
            ...item.style,
            r: 6,
          },
        };
      },
    },
    label: {
      position: 'right',
      style: {
        fill: '#0ff',
        fontSize: 16,
      },
      layout: [
        {
          type: 'fixed-overlap',
        },
      ],
    },
    color: ['#33cfea', '#50bc67', '#ffc000'],
    pieStyle: {
      lineWidth: 0,
    },
    statistic: {
      title: false,
      content: false,
    },
  };

  return (
    <div className={styles.main}>
      <div className={styles.header}>非生产工时</div>
      <div className={styles.content}>
        <Pie {...config} />
      </div>
    </div>
  );
};

export default WorkTimeUnproduct;
