import React from 'react';
import type { ColumnConfig } from '@ant-design/plots';
import { Column } from '@ant-design/plots';
import styles from './index.less';

type WorkTimeProps = {
  conditionKey: string;
};

const convertData = () => {
  const data: { label: string; type: string; value: number }[] = [];
  data.push({
    label: 'T',
    type: '上报工时',
    value: 300,
  });
  data.push({
    label: 'T',
    type: '非生产工时',
    value: 50,
  });
  return data;
};

const getAxisMax = (data: { value: number }[]) => {
  let max = 0;
  data.forEach((item) => {
    if (max < item.value) {
      max = item.value;
    }
  });
  return max * 1.1;
};

const WorkTime: React.FC<WorkTimeProps> = ({}) => {
  const data = convertData();
  const axisMax = getAxisMax(data);

  const config: ColumnConfig & React.RefAttributes<unknown> = {
    data: data,
    isGroup: true,
    xField: 'label',
    yField: 'value',
    seriesField: 'type',
    color: ['l(90) 0:#00d3d7 1:#00263a', 'l(90) 0:#cf474d 1:#18162a'],
    yAxis: {
      line: null,
      grid: null,
      title: null,
      label: null,
      max: axisMax,
    },
    xAxis: {
      line: null,
      tickLine: null,
      label: null,
    },
    legend: {
      layout: 'vertical',
      position: 'top-right',
      itemName: {
        style: {
          fill: '#0ff',
          fontSize: 16,
        },
      },
      marker: (_name, _index, item) => {
        return {
          ...item,
          style: {
            ...item.style,
            r: 6,
          },
        };
      },
    },
    autoFit: true,
    marginRatio: 0,
    label: {
      position: 'top',
      style: {
        fill: '#0ff',
        fontSize: 20,
      },
      layout: [
        {
          type: 'fixed-overlap',
        },
      ],
    },
  };

  return (
    <div className={styles.main}>
      <div className={styles.header}>人效工时</div>
      <div className={styles.content}>
        <Column {...config} />
      </div>
    </div>
  );
};

export default WorkTime;
