import { request } from 'umi';

export type CommonParams = {
  worksiteName: string;
  processConfs: {
    werks: string;
    fevor: string;
    operationName: string;
  }[];
  workUnitConfs: {
    ordinal: number;
    device: string;
    deviceName: string;
    operationUnit: string;
  }[];
};

export type StatisTableDto = {
  plan: KANBAN.AirBottleProcessKanban.StatisTableColumnDto;
  workUnitAmount: KANBAN.AirBottleProcessKanban.StatisTableColumnDto;
  workUnitDataList: KANBAN.AirBottleProcessKanban.StatisTableColumnDto;
  workUnitList: string[];
};

export async function queryQPKanbanSetting() {
  return request<Api.ServiceResult<KANBAN.AirBottleProcessKanban.SettingData[]>>(
    '/api/qiPingProcessKanbanSetting/list',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
    },
  );
}

export async function queryQPStatisIndex(data: CommonParams) {
  return request<Api.ServiceResult<KANBAN.AirBottleProcessKanban.StatisIndexDto>>(
    '/api/qiPingProcessData/statisIndex',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data,
    },
  );
}

export async function queryQPStatisTableIndex(data: CommonParams) {
  return request<Api.ServiceResult<StatisTableDto>>('/qiPingProcessData/statisTableIndex', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data,
  });
}
export async function queryQPStatisQuantityByMonthDay(data: CommonParams) {
  return request<Api.ServiceResult<KANBAN.AirBottleProcessKanban.ChartDataDto[]>>(
    '/api/qiPingProcessData/statisQuantityByMonthDay',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data,
    },
  );
}
export async function queryQPStatisQuantityByYearMonth(data: CommonParams) {
  return request<Api.ServiceResult<KANBAN.AirBottleProcessKanban.ChartDataDto[]>>(
    '/api/qiPingProcessData/statisQuantityByYearMonth',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data,
    },
  );
}
