import React, { useState, useEffect, useMemo, useCallback, useRef } from 'react';
import styles from './index.less';
import moment from 'moment';
import { useIntl } from 'umi';

type ProductionProgressKanbanData = KANBAN.ProductionProgress.ProductionProgressKanbanDataDto;

type ProgressTableProps = {
  lineName: string;
  data: object;
  conditionKey: string;
  rowMovingTime: number;
};

const ProgressTable: React.FC<ProgressTableProps> = ({
  lineName,
  data,
  conditionKey,
  rowMovingTime,
}) => {
  const rowHight = 72;
  const [displayData, setDisplayData] = useState<ProductionProgressKanbanData[]>([]);
  const leftScroll = useRef<HTMLDivElement>(null);
  let timer: NodeJS.Timer | null = null;
  const intl = useIntl();
  



  useEffect(() => {
    setDisplayData(data.taskPlanDayList || [])
    stopLoop()
    startLoop()
    return () => {
      stopLoop()
    }
  }, [rowMovingTime, data]);

  const stopLoop = () => {
    if (timer) {
      clearInterval(timer);
      timer = null;
    }
  };
  const onMouseEnter = () => {
    stopLoop()
  }
  const onMouseLeave = () => {
    startLoop()
  }
  const startLoop = () => {
    stopLoop();
    if (leftScroll && leftScroll.current && (leftScroll.current.scrollTop || leftScroll.current.scrollTop === 0)) {
      timer = setInterval(() => {
        if(!leftScroll || !leftScroll.current) return
        let scrollTop = leftScroll.current.scrollTop
        console.log(scrollTop, leftScroll.current.offsetHeight, leftScroll.current.scrollHeight)
        if (scrollTop + leftScroll.current.offsetHeight + 5 >= leftScroll.current.scrollHeight) {
          leftScroll.current.scrollTo({
            top: 0, 
            behavior: 'instant',
          });
        } else {
          leftScroll.current.scrollTop += 60
        }
      }, rowMovingTime * 1000)
    }
  };

  return (
    <div className={styles.main} onMouseEnter={onMouseEnter}//移出关闭
    onMouseLeave={onMouseLeave}>
      <div className={styles.row_container} style={{ height: rowHight }}>
        <div className={styles.row_segment1}>
          <div
            className={`${styles.row_segment1_section1} ${styles.no_top_border} ${styles.no_left_border}`}
          >
            <div className={styles.cell}>{intl.formatMessage({id:'日期'})}</div>
          </div>
          <div className={`${styles.row_segment1_section2} ${styles.no_top_border}`}>
            <div className={styles.cell}>{intl.formatMessage({id:'产品'})}</div>
          </div>
          <div className={`${styles.row_segment1_section3} ${styles.no_top_border}`}>
            <div className={styles.cell}>{intl.formatMessage({id:'计划数'})}</div>
          </div>
          <div className={`${styles.row_segment1_section4_header} ${styles.no_top_border} ${styles.no_right_border}`}>
            <div className={styles.cell}>{intl.formatMessage({id:'工序'})}</div>
          </div>
        </div>
      </div>
      <div className={styles.scrollMain}>
        <div ref={leftScroll} className={styles.leftWrapper} >
          {displayData.map((node: any, index: number) => (
            <div
              className={styles.row_container}
              key={index}
            >
              <div className={styles.row_segment1}>
                <div
                  className={styles.row_segment1_section1}
                >
                  <div className={styles.cell}>{node['startDate']}</div>
                </div>
                <div className={styles.processlist}>
                  {node.productList.map((item: any, index1: number) => (
                    <div className={`${styles.row_container} ${styles.other_data}`} key={'processitem' + index1}>
                      <div className={styles.row_segment1_section2}>
                        <div className={styles.cell}>{item.itemCode}</div>
                      </div>
                      <div className={styles.row_segment1_section3}>
                        <div className={styles.cell}>{item.planQuantity}</div>
                      </div>
                      <div className={styles.row_segment1_section4}>
                        {item.processList.map((processitem: any, processindex: number) => (
                          <div className={styles.process_item} key={processindex} style={{
                              height: rowHight,
                              background: processitem.state === 2 ? '#ffc000' : processitem.state === 1 ? '#009242' : 'transparent'
                            }}>
                            <div className={styles.cell}>{processitem.processName}</div>
                            <div className={styles.process_value}>
                              <div className={styles.cell}>{processitem.reportQuantity}</div>
                              <div className={styles.cell}>{processitem.qualifyQuantity}</div>
                              <div className={styles.cell}>{processitem.qualifiedRate}%</div>
                            </div>
                            
                          </div>
                        ))}
                      </div>
                    </div>
                  ))}
                </div>
                  
              </div>
              {/* 
              <div className={styles.row_segment2}>
                {lineName.progress.steps.map((step) => (
                  <div
                    className={styles.row_section}
                    style={{ width: row_segment2_section_width }}
                    key={step.code}
                  >
                    <StepCell step={step} data={node.data} lineName={lineName} />
                  </div>
                ))}
              </div> */}
            </div>
          ))}
        </div>
      </div>
      
    </div>
  );
};

export default ProgressTable;
