// @ts-ignore
/* eslint-disable */
import { request } from 'umi';
import { graphql } from '@/services/common';
import moment from 'moment';

/**
 * 月计划查询
 * @param params
 * @param options?
 */
export async function query(
  params: Report.Settings.MonthlyPlanCriteria,
  options?: { [p: string]: any },
) {
  const specification: string[] = [];
  if (params.id && params.id.length > 0) {
    specification.push(`id: {_v: eq,_val: ${params.id}}`);
  }
  const query = `{${specification.join(',')}}`;
  const gqlString = `query{
            monthlyPlan(
              specification:${query},
              sort:{
                orders:[
                {
                  pty:"werks",
                  dir:asc
                },
                {
                  pty:"fevor",
                  dir:asc
                },
                {
                  pty:"month",
                  dir:asc
                }]
              }){
                id,
                werks,
                fevor,
                month,
                quantity,
              }
          }`;
  const graphqlParams: Common.GraphqlParams = {
    operationName: null,
    variables: null,
    query: gqlString,
  };
  const result = await graphql(graphqlParams, options);
  return result.data.monthlyPlan as Report.Settings.MonthlyPlanDto[];
}

/**
 * 月计划分页查询
 * @param params
 * @param options?
 */
export async function pageQuery(
  params: Report.Settings.MonthlyPlanPageCriteria,
  options?: { [p: string]: any },
) {
  const specification: string[] = [];
  if (params.werks && params.werks.length > 0) {
    specification.push(`werks: {_v: like,_val: "%${params.werks}%"}`);
  }
  if (params.fevor && params.fevor.length > 0) {
    specification.push(`fevor: {_v: like,_val: "%${params.fevor}%"}`);
  }
  // 日期格式转换
  const monthRange: [string, string] = [
    moment(params.monthRange ? params.monthRange[0] : undefined)?.format('YYYY-MM-DD HH:mm:ss'),
    moment(params.monthRange ? params.monthRange[1] : undefined)?.format('YYYY-MM-DD HH:mm:ss'),
  ];
  if (
    params.monthRange &&
    monthRange &&
    monthRange[0] &&
    monthRange[0].length > 0 &&
    monthRange[1] &&
    monthRange[1].length > 0
  ) {
    specification.push(`month: {_v: btw,_val: "${monthRange[0]}",_to: "${monthRange[1]}"}`);
  }
  const query = `{${specification.join(',')}}`;
  const gqlString = `query{
            monthlyPlanPage(
              pageable:{
                page:${params.current - 1},
                size:${params.pageSize},
                sort:{
                    orders:[
                    {
                      pty:"werks",
                      dir:asc
                    },
                    {
                      pty:"fevor",
                      dir:asc
                    },
                    {
                      pty:"month",
                      dir:asc
                    }]
                  }
                },
              specification:${query}){
                totalPages,
                totalElements,
                content{
                  id,
                  werks,
                  fevor,
                  month,
                  quantity,
                }
              }
          }`;
  const graphqlParams: Common.GraphqlParams = {
    operationName: null,
    variables: null,
    query: gqlString,
  };
  const result = await graphql(graphqlParams, options);
  const pageResult: Common.PageResult<Report.Settings.MonthlyPlanDto> = {
    current: params.current,
    pageSize: params.pageSize,
    total: result.data.monthlyPlanPage.totalElements,
    data: result.data.monthlyPlanPage.content,
  };
  return pageResult;
}

/**
 * 月计划创建
 * @param body
 * @param options
 */
export async function create(
  body: Report.Settings.MonthlyPlanCreate,
  options?: { [key: string]: any },
) {
  return request<Common.ServiceResult<string>>('/monthlyPlan/create', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

/**
 * 月计划更新
 * @param body
 * @param options
 */
export async function update(
  body: Report.Settings.MonthlyPlanUpdate,
  options?: { [key: string]: any },
) {
  return request<Common.ServiceResult<string>>('/monthlyPlan/update', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

/**
 * 月计划删除
 * @param body
 * @param options
 */
export async function remove(body: Common.RemoveDto, options?: { [key: string]: any }) {
  return request<Common.ServiceResult<string>>(`/api/monthlyPlan/remove`, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}
