// @ts-ignore
/* eslint-disable */

declare namespace Api {
  type ServiceResult<T> = {
    success: boolean;
    data: T;
    errorCode: string;
    errorMessage: string;
    showType: number;
    traceId: string;
    host: string;
  };

  type Order = {
    property: string;
    direction: 'ASC' | 'DESC';
  };

  type Sort = {
    orders: Order[];
  };

  type PageParams = {
    current: number;
    pageSize: number;
    sort?: Sort;
  };

  type PageResult<T> = {
    current: number;
    pageSize: number;
    total: number;
    data: T[];
  };

  type ServiceResultMes<T> = {
    Success: boolean;
    Data: T;
    ErrorCode: string;
    ErrorMessage: string;
    ShowType: number;
    TraceId: string;
    Host: string;
  };

  type PageResultMes<T> = {
    pageIndex: number;
    pageSize: number;
    pageRange: number;
    pageCount: number;
    totalCount: number;
    result: T[];
  };

  type IdDto = {
    id: string;
  };

  type RemoveDto = {
    id: string;
  };

  type GraphqlParams = {
    operationName: string | null;
    variables: any;
    query?: string;
  };

  type GraphqlResult = {
    data: any;
    errors: any[];
  };

  type GraphqlPage = {
    totalPages: number;
    totalElements: number;
    content: any[];
  };

  type ActorDto = {
    identifier: string;
    description: string;
  } & IdDto;

  type CurrentUser = {
    user: T;
    roles: any[];
    code: number;
  };

  type CurrentAccount = {
    type: string;
    data: any;
  };

  type FileInforDto = {
    name: string;
    extension: string;
    uri: string;
  } & IdDto;

  type FileInforPageCriteria = {
    name?: string;
    extension?: string;
  } & Api.PageParams;

  type LoginMgrParams = {
    username: string;
    password: string;
    autoLogin: boolean;
  };

  type LoginPubParams = {
    username: string;
    password: string;
    phone: string;
    captcha: string;
    autoLogin: boolean;
    type: string;
  };

  type LoginResult = {
    token: string;
  };

  type EmployeeDto = {
    workNo: string;
    name: string;
    email: string;
    phone: string;
  } & IdDto;

  type EmployeeUpdateParams = {
    name: string;
    email: string;
    phone: string;
  } & IdDto;

  type SingleTableCreateParams = {
    code?: string;
    name?: string;
    description?: string;
    entityMetadata?: string;
    canCreate?: string;
    canEdit?: string;
    canRemove?: string;
  };

  type SingleTableUpdateParams = {
    name?: string;
    description?: string;
    entityMetadata?: string;
    canCreate?: string;
    canEdit?: string;
    canRemove?: string;
  } & IdDto;

  type SingleTableFieldCreateParams = {
    code?: string;
    name?: string;
    valueType?: string;
    hideInSearch?: boolean;
    hideInTable?: boolean;
    hideInCreateForm?: boolean;
    hideInEditForm?: boolean;
    singleTable?: string;
  };

  type SingleTableFieldUpdateParams = {
    name?: string;
    valueType?: string;
    hideInSearch?: boolean;
    hideInTable?: boolean;
    hideInCreateForm?: boolean;
    hideInEditForm?: boolean;
    singleTable?: string;
  } & IdDto;

  type EntityMetadata = {
    id: string;
    code: string;
    name: string;
    description: string;
    type: string;
    propertys: EntityPropertyMetadata[];
  };

  type EntityPropertyMetadata = {
    id: string;
    code: string;
    name: string;
    description: string;
    genericType: string;
    type: string;
  };

  type SingleTable = {
    id: string;
    code: string;
    name: string;
    description: string;
    entityMetadata: EntityMetadata;
    canCreate: string;
    canEdit: string;
    canRemove: string;
    canImport: string;
    canExport: string;
    orders?: string;
    scroll?: string;
    fields: SingleTableField[];
    createAccess: string;
    editAccess: string;
    removeAccess: string;
    importAccess: string;
  };

  type SingleTableField = {
    id: string;
    code: string;
    name: string;
    ordinal: number;
    valueType: string;
    dataType: string;
    hideInSearch: boolean;
    hideInTable: boolean;
    hideInCreateForm: boolean;
    hideInEditForm: boolean;
    required: boolean;
    colSize?: number;
    width?: number;
    keys: string;
    display: string;
  };

  type RptOeeQueryParams = {
    names: string[];
    from: string;
    to: string;
  };

  type RptOee = {
    name: string;
    planTime: number;
    actualTime: number;
    scheduledTime: number;
  } & IdDto;

  type RptEquipmentOee = {
    name: string;
    description: string;
    workSiteName: string;
    workCenterName: string;
    schdTime: number;
    taskReportTime: number;
    equipmentReportTime: number;
    equipmentTime: number;
    overdueTime: number;
  } & IdDto;
}
