import { useEffect, useState } from 'react';
import KanbanStyle from '../components/FHD1080P/Style2';
import SettingForm from './components/SettingForm';
import type { Setting } from './components/SettingForm';
import './index.less';
import { YuanZhao, HeLongFeng } from './components/ZongFeng';
import { EvaluateNum, DefectDistribution, EvaluateDistribution } from './components/Evaluate';
import { queryCountHjKanbanData } from './services/api';
import type { CountHjKanbanDataDto } from './services/api';

const WeldingProcessKanban: React.FC = () => {
  const [setting, setSetting] = useState<Setting>({
    autoResize: true,
    intervalTime: 600,
    rowMovingTime: 5,
    weldingProcessSetting: undefined,
    kanbanId: '',
  });
  const [kanbanData, setKanbanData] = useState<CountHjKanbanDataDto>({
    rateAndNumber: {
      passNumber: 0,
      noPassNumber: 0,
      passRate: 0,
    },
    yzDataList: [],
    hlfDataList: [],
    dayAndNumberList: [],
    dayHfChangedList: [],
    monthHfChangedList: [],
  });

  const [settingFormVisible, setSettingFormVisible] = useState(false);

  useEffect(() => {
    const { kanbanId, intervalTime } = setting;
    let t: NodeJS.Timer | null = null;
    if (!kanbanId) {
      setKanbanData({
        rateAndNumber: {
          passNumber: 0,
          noPassNumber: 0,
          passRate: 0,
        },
        yzDataList: [],
        hlfDataList: [],
        dayAndNumberList: [],
        dayHfChangedList: [],
        monthHfChangedList: [],
      });

      if (t !== null) {
        clearInterval(t);
      }
      return;
    }

    const refresh = () => {
      queryCountHjKanbanData({ settingId: setting.kanbanId }).then((res) => {
        setKanbanData(res.data);
      });
    };

    refresh();

    t = setInterval(() => {
      refresh();
    }, intervalTime * 1000);

    return () => {
      if (t !== null) {
        clearInterval(t);
      }
    };
  }, [setting]);

  return (
    <>
      <KanbanStyle
        headerText="工序看板"
        subTitle={setting.weldingProcessSetting?.title}
        autoResize={setting.autoResize}
        onHeaderClick={() => {
          setSettingFormVisible(true);
        }}
      >
        <div className="page-container">
          <div className="page-left-container">
            <YuanZhao setting={setting} data={kanbanData.yzDataList} />
            <HeLongFeng setting={setting} data={kanbanData.hlfDataList} />
          </div>
          <div className="page-right-container">
            <EvaluateNum data={kanbanData.rateAndNumber} />
            <DefectDistribution
              month={kanbanData.monthHfChangedList}
              day={kanbanData.dayHfChangedList}
              settingId={setting.kanbanId}
            />
            <EvaluateDistribution data={kanbanData.dayAndNumberList} />
          </div>
        </div>
      </KanbanStyle>
      <SettingForm
        values={{ ...setting }}
        visible={settingFormVisible}
        onVisibleChange={setSettingFormVisible}
        onSubmitting={async (settingParams) => {
          setSetting({ ...settingParams });
        }}
      />
    </>
  );
};

export default WeldingProcessKanban;
