import ProTable, { ActionType } from '@ant-design/pro-table';
import { queryProcessFailQualityError } from '@/pages/kanban/qipingComprehens/services/api';
import React, { useEffect, useRef } from 'react';

const QualityErrorTable: React.FC<{ params: any }> = ({ params }) => {
  const actionRef = useRef<ActionType>();
  useEffect(() => {
    actionRef.current?.reload();
  }, [params]);

  const columns = [
    {
      title: '批次号',
      dataIndex: 'lotNo',
      key: 'lotNo',
      width: 100,
    },
    {
      title: '异常时间',
      dataIndex: 'eventDate',
      key: 'eventDate',
      width: 120,
    },
  ];
  return (
    <>
      <ProTable
        options={false}
        search={false}
        actionRef={actionRef}
        request={async () => {
          const sr = await queryProcessFailQualityError({ ...params });
          const pageResult: Common.PageResult<any> = {
            current: params.current,
            pageSize: params.pageSize,
            total: sr.data.total,
            data: sr.data.data,
          };
          return pageResult;
        }}
        pagination={{
          pageSize: 10,
        }}
        columns={columns}
        size={'middle'}
        bordered
      />
    </>
  );
};

export default QualityErrorTable;
