import PassTower from './passTower';
import PassSlice from './passSlice';
import styles from '../../index.less';
import { Modal } from 'antd';
import { useState } from 'react';
import PassingRateChart from './passingRateChart';
import { queryCountWeldingPassRateTrendChart } from '../../services/api';

const PassingRate: React.FC<{ data: any; kanbanId: string | undefined }> = ({ data, kanbanId }) => {
  const [isModalOpen, setIsModalOpen] = useState(false);
  const closeModal = () => setIsModalOpen(false);
  const [chartData, setChartData] = useState<KANBAN.QiPingComprehens.PassRateTrendChart[]>([]);
  const openModal = async () => {
    if (!kanbanId) {
      return;
    }
    const { data: cData } = await queryCountWeldingPassRateTrendChart({
      kanbanSettingId: kanbanId,
    });
    setChartData(cData);
    setIsModalOpen(true);
  };
  return (
    <>
      <Modal
        title={'焊接一次通过率'}
        visible={isModalOpen}
        footer={null}
        width={'70%'}
        onCancel={closeModal}
      >
        <PassingRateChart data={chartData} />
      </Modal>
      <div
        className={styles.rightTopBottomItem}
        onClick={openModal}
        style={{ background: '#040f24' }}
      >
        <p>整台</p>
        <div style={{ height: '150px' }}>
          <PassTower data={data.wholeSetPassRate} />
        </div>
      </div>
      <div className={styles.rightTopBottomItem} style={{ marginRight: '0px' }}>
        <p>按片</p>
        <div style={{ height: '150px' }}>
          <PassSlice data={data.piecePassRate} />
        </div>
      </div>
    </>
  );
};

export default PassingRate;
