import ProTable, { ActionType } from '@ant-design/pro-table';
import { queryEquipmentDetail } from '@/pages/kanban/productionComprehens/services/api';
import React, { useEffect, useRef } from 'react';
type EquipmentDetailCriteria = KANBAN.ProductionComprehens.EquipmentDetailCriteria;

export type InfoProps = {
  values: EquipmentDetailCriteria;
};

const DeviceCountTable: React.FC<InfoProps> = (props) => {
  const actionRef = useRef<ActionType>();
  useEffect(() => {
    actionRef.current?.reload();
  }, [props.values]);

  const columns = [
    {
      title: '设备编码',
      dataIndex: 'deviceNo',
      key: 'deviceNo',
      width: 100,
    },
    {
      title: '设备描述',
      dataIndex: 'description',
      key: 'description',
      width: 120,
    },
    {
      title: '车间',
      dataIndex: 'workSiteName',
      key: 'workSiteName',
      width: 120,
    },
    {
      title: '车间描述',
      dataIndex: 'workSiteDescription',
      key: 'workSiteDescription',
      width: 120,
    },
    {
      title: '设备状态',
      dataIndex: 'stateName',
      key: 'stateName',
      width: 70,
    },
    {
      title: '责任人',
      dataIndex: 'keeperName',
      key: 'keeperName',
      width: 100,
    },
    {
      title: '管理员',
      dataIndex: 'managerName',
      key: 'managerName',
      width: 100,
    },
    {
      title: '存放位置',
      dataIndex: 'position',
      key: 'position',
      width: 120,
    },
  ];
  return (
    <>
      <ProTable
        options={false}
        search={false}
        actionRef={actionRef}
        request={async (params: EquipmentDetailCriteria) => {
          const sr = await queryEquipmentDetail({
            ...props.values,
            pageSize: params.pageSize,
            current: params.current,
          });
          const pageResult: Common.PageResult<any> = {
            current: params.current,
            pageSize: params.pageSize,
            total: sr.data.total,
            data: sr.data.data,
          };
          return pageResult;
        }}
        pagination={{
          pageSize: 10,
        }}
        columns={columns}
        size={'middle'}
        bordered
        scroll={{ x: 2000 }}
      />
    </>
  );
};

export default DeviceCountTable;
