import React, { useEffect, useRef } from 'react';
import ProTable, { ActionType } from '@ant-design/pro-table';
import { queryEquipmentErrorDetail } from '@/pages/kanban/productionComprehens/services/api';

type ErrorDetailCriteria = KANBAN.ProductionComprehens.ErrorDetailCriteria;

export type InfoProps = {
  values: ErrorDetailCriteria;
};

const DeviceAbnormalTable: React.FC<InfoProps> = (props) => {
  const actionRef = useRef<ActionType>();
  useEffect(() => {
    actionRef.current?.reload();
  }, [props.values]);

  const columns = [
    {
      title: '单号',
      dataIndex: 'deNo',
      key: 'deNo',
      width: 120,
    },
    {
      title: '状态',
      dataIndex: 'deStateName',
      key: 'deStateName',
      width: 120,
    },
    {
      title: '车间',
      dataIndex: 'workSiteName',
      key: 'workSiteName',
      width: 120,
    },
    {
      title: '设备编号',
      dataIndex: 'deviceNo',
      key: 'deviceNo',
      width: 120,
    },
    {
      title: '设备描述',
      dataIndex: 'deviceDescription',
      key: 'deviceDescription',
      width: 120,
    },
    {
      title: '创建时间',
      dataIndex: 'createdDate',
      key: 'createdDate',
      width: 120,
    },
    {
      title: '创建人',
      dataIndex: 'createdByName',
      key: 'createdByName',
      width: 120,
    },
    {
      title: '完成时间',
      dataIndex: 'executedDate',
      key: 'executedDate',
      width: 120,
    },
    {
      title: '完成人',
      dataIndex: 'executedByName',
      key: 'executedByName',
      width: 120,
    },
    {
      title: '委托类型',
      dataIndex: 'delegateTypeName',
      key: 'delegateTypeName',
      width: 120,
    },
    {
      title: '异常现象组',
      dataIndex: 'deCaseGroupName',
      key: 'deCaseGroupName',
      width: 120,
    },
    {
      title: '异常现象',
      dataIndex: 'deCaseDetailName',
      key: 'deCaseDetailName',
      width: 120,
    },
    {
      title: '异常原因组',
      dataIndex: 'deReasonGroupName',
      key: 'deReasonGroupName',
      width: 120,
    },
    {
      title: '异常原因',
      dataIndex: 'deReasonDetailName',
      key: 'deReasonDetailName',
      width: 120,
    },
    {
      title: '异常策略组',
      dataIndex: 'deMethodGroupName',
      key: 'deMethodGroupName',
      width: 120,
    },
    {
      title: '异常策略',
      dataIndex: 'deMethodDetailName',
      key: 'deMethodDetailName',
      width: 120,
    },
    {
      title: '备注',
      dataIndex: 'remarks',
      key: 'remarks',
      width: 120,
    },
  ];

  return (
    <>
      <ProTable
        options={false}
        search={false}
        actionRef={actionRef}
        request={async (params: ErrorDetailCriteria) => {
          const sr = await queryEquipmentErrorDetail({
            ...props.values,
            pageSize: params.pageSize,
            current: params.current,
          });
          const pageResult: Common.PageResult<any> = {
            current: params.current,
            pageSize: params.pageSize,
            total: sr.data.total,
            data: sr.data.data,
          };
          return pageResult;
        }}
        pagination={{
          pageSize: 10,
        }}
        columns={columns}
        size={'middle'}
        bordered
        scroll={{ x: 2000 }}
      />
    </>
  );
};

export default DeviceAbnormalTable;
