import { statusList } from '@/services/machineConnectivity/api';
import React, { useEffect, useState } from 'react';
import Crust1 from '../../components/FHD1080P/Crust1';
import Style1 from '../../components/FHD1080P/Style1';
import MachineTable from './components/MachineTable';
import SettingForm from './components/SettingForm';
import type { Setting } from './components/SettingForm';
import styles from './index.less';

const Main: React.FC = () => {
  const [setting, setSetting] = useState<Setting>({
    autoResize: false,
    intervalTime: 600,
    rowMovingTime: 5,
    currentWorkSite: undefined,
    selectedWorkUnits: [],
  });

  const [settingFormVisible, setSettingFormVisible] = useState(false);
  const [machineStatusArray, setMachineStatusArray] = useState<MachineConnectivity.MachineStatus[]>(
    [],
  );
  const [conditionKey, setConditionKey] = useState('');

  const [ct, setCt] = useState({
    total: 111,
    running: 111,
    waiting: 0,
    shut_down: 111,
    wait: 111,
    production: 0,
    ready: 0,
    alarm: 111,
    setup: 0,
    manual_input: 0,
  });

  useEffect(() => {
    const { intervalTime, selectedWorkUnits } = setting;
    const refresh = () => {
      statusList({ machines: selectedWorkUnits.map((w) => w.name) }).then((value) => {
        setCt({
          ...value.ct,
          total: value.total,
          waiting: value.ct.wait + value.ct.ready,
          running:
            value.total - value.ct.shut_down - value.ct.wait - value.ct.ready - value.ct.alarm,
        });
        value.machineList.forEach((m) => {
          m.picName = selectedWorkUnits.filter((wu) => wu.name === m.machineName).pop()?.picName;
        });
        setMachineStatusArray(value.machineList);
        setConditionKey(Date.now().toString());
      });
    };
    refresh();
    const t = setInterval(() => {
      refresh();
    }, intervalTime * 1000);
    return () => {
      clearTimeout(t);
    };
  }, [setting]);

  return (
    <>
      <Style1
        headerText="设备状态看板"
        autoResize={setting.autoResize}
        onHeaderClick={() => {
          setSettingFormVisible(true);
        }}
      >
        <div className={styles.main}>
          <div className={styles.title}>
            <div className={styles.title_work_site}>
              <div
                className={
                  setting.currentWorkSite
                    ? styles.title_work_site_legend
                    : styles.title_work_site_legend_hidden
                }
              />
              <div className={styles.title_work_site_text}>{setting.currentWorkSite?.name}</div>
            </div>
            <div className={styles.title_machine_stat}>
              <div className={styles.title_machine_stat_item_l}>设备总数：{ct.total}</div>
              <div className={styles.title_machine_stat_item}>运行：{ct.running}</div>
              <div className={styles.title_machine_stat_item}>等待：{ct.waiting}</div>
              <div className={styles.title_machine_stat_item}>停机：{ct.shut_down}</div>
              <div className={styles.title_machine_stat_item}>报警：{ct.alarm}</div>
            </div>
            <div className={styles.title_machine_status}>
              <div className={styles.title_machine_status_text}>设备运行状态</div>
              <div className={styles.title_machine_status_legend}>
                <div className={styles.title_machine_status_legend_shut_down} />
                <div className={styles.title_machine_status_legend_alarm} />
                <div className={styles.title_machine_status_legend_wait} />
                <div className={styles.title_machine_status_legend_running} />
              </div>
            </div>
          </div>
          <div className={styles.content}>
            <Crust1>
              <div className={styles.content_machs}>
                <MachineTable
                  machineStatusArray={machineStatusArray}
                  conditionKey={conditionKey}
                  rowMovingTime={setting.rowMovingTime}
                />
              </div>
            </Crust1>
          </div>
        </div>
      </Style1>
      <SettingForm
        values={{ ...setting }}
        visible={settingFormVisible}
        onVisibleChange={setSettingFormVisible}
        onSubmitting={async (settingParams) => {
          setSetting({ ...settingParams });
        }}
      />
    </>
  );
};

export default Main;
