import React, { useEffect, useState } from 'react';
import SettingForm from './components/SettingForm';
import type { Setting } from './components/SettingForm';
import styles from './index.less';
import KanbanStyle from '../components/FHD1080P/Style2';
import Crust1 from '../components/FHD1080P/Crust1';
import { queryProductProgressKanbanData } from './services/api';
import moment from 'moment';
import FevorPanel from '@/pages/kanban/ProductProgress/components/FevorPanel';

type ProductProgressKanbanData = KANBAN.ProductProgress.ProductProgressKanbanDataDto;

const Main: React.FC = () => {
  const [setting, setSetting] = useState<Setting>({
    autoResize: true,
    intervalTime: 600,
    rowMovingTime: 5,
    productProgressKanbanSetting: undefined,
  });

  const [conditionKey, setConditionKey] = useState('');
  const [data, setData] = useState<ProductProgressKanbanData[]>([]);
  const [settingFormVisible, setSettingFormVisible] = useState(false);

  useEffect(() => {
    const { intervalTime, productProgressKanbanSetting } = setting;
    if (!!!productProgressKanbanSetting) {
      setConditionKey(Date.now().toString());
      setData([]);
      return;
    }
    let changeConditionKey = true;
    const refresh = () => {
      const now = Date.now();
      const gstrpFrom = moment(now).startOf('month');
      const gstrpTo = moment(now).endOf('month');

      queryProductProgressKanbanData({
        productProgressKanbanSettingId: productProgressKanbanSetting.id,
        gstrpFrom: gstrpFrom.format('YYYY-MM-DD HH:mm:ss'),
        gstrpTo: gstrpTo.format('YYYY-MM-DD HH:mm:ss'),
      })
        .then((value) => {
          setData(value.data);
          if (changeConditionKey) {
            changeConditionKey = false;
            setConditionKey(Date.now().toString());
          }
        })
        .catch(() => {});
    };
    refresh();
    const t = setInterval(() => {
      refresh();
    }, intervalTime * 1000);
    return () => {
      clearTimeout(t);
    };
  }, [setting]);

  return (
    <>
      <KanbanStyle
        headerText="产品进度看板"
        subTitle={setting.productProgressKanbanSetting?.subTitle1}
        autoResize={setting.autoResize}
        onHeaderClick={() => {
          setSettingFormVisible(true);
        }}
      >
        <div className={styles.main}>
          <div className={styles.title}>
            <div className={styles.title_left}>
              <div
                className={
                  setting.productProgressKanbanSetting?.subTitle2
                    ? styles.title_left_legend
                    : styles.title_left_legend_hidden
                }
              />
              <div className={styles.title_left_text}>
                {setting.productProgressKanbanSetting?.subTitle2}
              </div>
            </div>
            <div className={styles.title_center} />
          </div>
          <div className={styles.content}>
            <Crust1 className={styles.crust}>
              <div className={styles.content_machs_1}>
                {setting.productProgressKanbanSetting && (
                  <FevorPanel
                    setting={setting.productProgressKanbanSetting}
                    data={data}
                    conditionKey={conditionKey}
                    rowMovingTime={setting.rowMovingTime}
                  />
                )}
              </div>
            </Crust1>
          </div>
        </div>
      </KanbanStyle>
      <SettingForm
        values={{ ...setting }}
        visible={settingFormVisible}
        onVisibleChange={setSettingFormVisible}
        onSubmitting={async (settingParams) => {
          setSetting({ ...settingParams });
        }}
      />
    </>
  );
};

export default Main;
