// import { graphql } from '@/services/common';
import { request } from 'umi';
type HFChangedInfoDataDto = KANBAN.WeldingProcessKanban.HFChangedInfoDataDto;
type WeldingProcessSetting = KANBAN.WeldingProcessKanban.WeldingProcessSetting;

export type CountHjKanbanDataDto = {
  rateAndNumber: KANBAN.WeldingProcessKanban.RateAndNumberDto;
  yzDataList: KANBAN.WeldingProcessKanban.DataListDto[];
  hlfDataList: KANBAN.WeldingProcessKanban.DataListDto[];
  dayAndNumberList: KANBAN.WeldingProcessKanban.DayAndNumberListDto[];
  dayHfChangedList: { repairCause: string; number: number }[];
  monthHfChangedList: { repairCause: string; number: number }[];
};

export async function queryHjKanbanSetting() {
  return request<Api.ServiceResult<WeldingProcessSetting[]>>('/hjKanbanSetting/query', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
  });
}

export async function queryCountHjKanbanData(params: { settingId: string }) {
  return request<Api.ServiceResult<CountHjKanbanDataDto>>('/hjKanbanData/countHjKanbanData', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    params,
  });
}

// 焊缝变更数据查询
export async function queryHFChangedInfoDataDto(
  params: { kanbanSettingId: string; type: number },
  options?: { [key: string]: any },
) {
  return request<Api.ServiceResult<HFChangedInfoDataDto[]>>('/hfChangedInfoData/find', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: params,
    ...(options || {}),
  });
}
