import React, { useRef } from 'react';
import type { ProFormInstance } from '@ant-design/pro-form';
import { DrawerForm, ProFormDatePicker, ProFormGroup, ProFormText } from '@ant-design/pro-form';
import serviceClient from '@/services/report/settings/index';

export type CreateFormProps = {
  visible: boolean;
  onVisibleChange: (visible: boolean) => void;
  onSubmitting: () => Promise<any>;
  onSuccess: (params: any) => Promise<void>;
  onError: (params: any, error: unknown) => Promise<void>;
};

const CreateForm: React.FC<CreateFormProps> = (props) => {
  const formRef = useRef<ProFormInstance>();
  return (
    <DrawerForm
      formRef={formRef}
      title="新增高压喷漆工序看板数据"
      width="900px"
      visible={props.visible}
      onVisibleChange={(visible: boolean) => {
        if (visible) {
          formRef?.current?.resetFields();
        }
        props.onVisibleChange(visible);
      }}
      onFinish={async () => {
        const formData = formRef?.current?.getFieldsValue();
        const params = await props.onSubmitting();
        try {
          const createDto: Report.Settings.GaoYaProcessDataCreate = {
            operationName: formData.operationName,
            date: formData.date,
            type: formData.type,
            planNumber: formData.planNumber,
            actNumber: formData.actNumber,
            qiFangNo: formData.qiFangNo,
          };
          await serviceClient.gaoYaProcessDataService.create(createDto);
          await props.onSuccess(params);
        } catch (error) {
          await props.onError(params, error);
        }
      }}
    >
      <ProFormGroup>
        <ProFormText
          name="operationName"
          label={'工序名称'}
          width="md"
          rules={[{ required: true }]}
        />
        <ProFormDatePicker name="date" label={'日期'} width="md" rules={[{ required: true }]} />
        <ProFormText name="type" label={'类别'} width="md" rules={[{ required: true }]} />
        <ProFormText
          name="planNumber"
          label={'计划完工数量'}
          width="md"
          rules={[{ required: true }]}
        />
        <ProFormText
          name="actNumber"
          label={'实际完工数量'}
          width="md"
          rules={[{ required: true }]}
        />
        <ProFormText name="qiFangNo" label={'漆房编号'} width="md" rules={[{ required: true }]} />
      </ProFormGroup>
    </DrawerForm>
  );
};

export default CreateForm;
