import { request } from 'umi';

export type GaoYaProcessStandardDailyData = {
  monthAndNumberList: KANBAN.PaintingProcessKanban.MonthAndNumberListDto[];
  dayAndNumberList: KANBAN.PaintingProcessKanban.DayAndNumberListDto[];
  finishPlanRate: KANBAN.PaintingProcessKanban.FinishPlanRateDto;
  processDayDataList: {
    id: string;
    operationName: string;
    type: string;
    gaoYaProcessDataStepList: KANBAN.PaintingProcessKanban.GaoYaProcessDataStepListDto[];
  }[];
};

export async function queryGYKanbanSetting() {
  return request<Api.ServiceResult<KANBAN.PaintingProcessKanban.SettingData[]>>(
    '/api/gaoYaProcessKanbanSetting/query',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
    },
  );
}

export async function queryGYStandardDailyData(params: { settingId: string }) {
  return request<Api.ServiceResult<GaoYaProcessStandardDailyData>>(
    '/api/gaoYaProcessStandardDailyData/count',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      params,
    },
  );
}
