import { useEffect, useState } from 'react';
import KanbanStyle from '../components/FHD1080P/Style2';
import SettingForm from './components/SettingForm';
import type { Setting } from './components/SettingForm';
import CountTable from './components/CountTable';
import FinishRate from './components/FinishRate';
import './index.less';
import OutputChart from './components/OutputChart';
import type { GaoYaProcessStandardDailyData } from './services/api';
import { queryGYStandardDailyData } from './services/api';

const AirBottleProcessKanban: React.FC = () => {
  const [setting, setSetting] = useState<Setting>({
    autoResize: true,
    intervalTime: 600,
    rowMovingTime: 5,
    gYProgressKanbanSetting: undefined,
    kanbanId: '',
  });
  const [settingFormVisible, setSettingFormVisible] = useState(false);
  const [kanbanData, setKanbanData] = useState<GaoYaProcessStandardDailyData>({
    processDayDataList: [],
    finishPlanRate: {
      monthPlanNumber: 0,
      monthActNumber: 0,
      finishPlanRate: 0,
    },
    dayAndNumberList: [],
    monthAndNumberList: [],
  });

  useEffect(() => {
    const { kanbanId, intervalTime } = setting;
    let t: NodeJS.Timer | null = null;
    if (!kanbanId) {
      setKanbanData({
        processDayDataList: [],
        finishPlanRate: {
          monthPlanNumber: 0,
          monthActNumber: 0,
          finishPlanRate: 0,
        },
        dayAndNumberList: [],
        monthAndNumberList: [],
      });

      if (t !== null) {
        clearInterval(t);
      }
      return;
    }

    const refresh = () => {
      queryGYStandardDailyData({ settingId: setting.kanbanId }).then((res) => {
        setKanbanData(res.data);
      });
    };

    refresh();

    t = setInterval(() => {
      refresh();
    }, intervalTime * 1000);

    return () => {
      if (t !== null) {
        clearInterval(t);
      }
    };
  }, [setting]);

  return (
    <>
      <KanbanStyle
        headerText="工序看板"
        subTitle={setting.gYProgressKanbanSetting?.title}
        autoResize={setting.autoResize}
        onHeaderClick={() => {
          setSettingFormVisible(true);
        }}
      >
        <div className="page-container">
          <div className="wrap">
            <div className="top-container">
              <div className="table-container">
                {setting.kanbanId ? (
                  <CountTable data={kanbanData.processDayDataList} setting={setting} />
                ) : (
                  ''
                )}
              </div>
              <div className="count-container">
                <div className="top-count">
                  <div className="left-count">
                    <p>本月计划</p>
                    <h1>{kanbanData.finishPlanRate.monthPlanNumber}</h1>
                  </div>
                  <div className="right-count">
                    <p>实际累计</p>
                    <h1>{kanbanData.finishPlanRate.monthActNumber}</h1>
                  </div>
                </div>

                <div className="finish-rate">
                  <FinishRate data={kanbanData.finishPlanRate.finishPlanRate} />
                </div>
              </div>
            </div>

            <div className="bottom-container">
              <div className="left">
                <OutputChart title="当月产量趋势图" data={kanbanData.dayAndNumberList} />
              </div>
              <div className="right">
                <OutputChart
                  title="当年产量趋势图"
                  data={kanbanData.monthAndNumberList}
                  color={'#f2c042'}
                />
              </div>
            </div>
          </div>
        </div>
      </KanbanStyle>
      <SettingForm
        values={{ ...setting }}
        visible={settingFormVisible}
        onVisibleChange={setSettingFormVisible}
        onSubmitting={async (settingParams) => {
          setSetting({ ...settingParams });
        }}
      />
    </>
  );
};

export default AirBottleProcessKanban;
