import ProTable, { ActionType } from '@ant-design/pro-table';
import React, { useEffect, useRef } from 'react';
import { queryPartProgress } from '@/pages/kanban/materialSynthesis/services/api';

type PartProgressDetailCriteria = KANBAN.MaterialSynthesis.PartProgressDetailCriteria;

export type InfoProps = {
  values: PartProgressDetailCriteria;
};

const PartModalTable: React.FC<InfoProps> = (props) => {
  const actionRef = useRef<ActionType>();
  useEffect(() => {
    actionRef.current?.reload();
  }, [props.values]);

  const columns = [
    {
      title: '批号',
      dataIndex: 'lotNo',
      key: 'lotNo',
      width: 120,
    },
    {
      title: '物料编码',
      dataIndex: 'partCode',
      key: 'partCode',
      width: 120,
    },
    {
      title: '物料描述',
      dataIndex: 'partName',
      key: 'partName',
      width: 120,
    },
    {
      title: '工序名称',
      dataIndex: 'operationName',
      key: 'operationName',
      width: 120,
    },
  ];

  return (
    <>
      <ProTable
        options={false}
        search={false}
        actionRef={actionRef}
        request={async (params: PartProgressDetailCriteria) => {
          const sr = await queryPartProgress({
            ...props.values,
            pageSize: params.pageSize,
            current: params.current,
          });
          const pageResult: Common.PageResult<any> = {
            current: params.current,
            pageSize: params.pageSize,
            total: sr.data.total,
            data: sr.data.data,
          };
          return pageResult;
        }}
        pagination={{
          pageSize: 10,
        }}
        columns={columns}
        size={'middle'}
        bordered
        scroll={{ x: 400 }}
      />
    </>
  );
};

export default PartModalTable;
