import { queryMaterialComprehensiveKanbanDataByWorkLine } from '@/pages/kanban/materialSynthesis/services/api';
import ProTable, { ActionType } from '@ant-design/pro-table';
import { useEffect, useRef } from 'react';

const MissingMaterialInfo: React.FC<{ params: any }> = ({ params }) => {
  const actionRef = useRef<ActionType>();
  useEffect(() => {
    actionRef.current?.reload();
  }, [params]);

  const columns = [
    {
      title: '施工号',
      dataIndex: 'sgNo',
      key: 'sgNo',
      width: 200,
    },
    {
      title: '物料名称',
      dataIndex: 'partName',
      key: 'partName',
      width: 200,
    },
    {
      title: '超期天数',
      dataIndex: 'beyondDays',
      key: 'beyondDays',
      width: 100,
    },
    {
      title: '回厂时间',
      dataIndex: 'backDate',
      key: 'backDate',
    },
  ];

  return (
    <>
      <ProTable
        options={false}
        search={false}
        actionRef={actionRef}
        request={async () => {
          const sr = await queryMaterialComprehensiveKanbanDataByWorkLine({ ...params });
          // const sr = await queryPageByKanbanPenetrating({ ...params });
          sr.data.forEach((v, i) => (v.key = i + 1));
          const pageResult = {
            data: sr.data,
          };
          return pageResult;
        }}
        pagination={{ pageSize: 10 }}
        columns={columns}
        size={'middle'}
        bordered
        scroll={{ x: 1100 }}
      />
    </>
  );
};

export default MissingMaterialInfo;
