import { queryPageByKanbanPenetrating } from '@/pages/kanban/productionComprehens/services/api';
import ProTable, { ActionType } from '@ant-design/pro-table';
import { useEffect, useRef } from 'react';

const OrderModalTable: React.FC<{ params: any }> = ({ params }) => {
  const actionRef = useRef<ActionType>();
  useEffect(() => {
    actionRef.current?.setPageInfo({
      current: 1,
    });
    actionRef.current?.reload();
  }, [params]);

  const columns = [
    {
      title: '批号',
      dataIndex: 'lotNo',
      key: 'lotNo',
      width: 100,
    },
    {
      title: '生产订单',
      dataIndex: 'aufnr',
      key: 'aufnr',
      width: 100,
    },
    {
      title: '工厂',
      dataIndex: 'werks',
      key: 'werks',
      width: 60,
    },
    {
      title: '生产管理员',
      dataIndex: 'fevor',
      key: 'fevor',
      width: 60,
    },
    {
      title: '基本开始日期',
      dataIndex: 'gstrp',
      key: 'gstrp',
      width: 110,
    },
    {
      title: '基本结束日期',
      dataIndex: 'gltrp',
      key: 'gstrp',
      width: 110,
    },
    {
      title: '实际开始日期',
      dataIndex: 'actualStartDate',
      key: 'actualStartDate',
      width: 110,
    },
    {
      title: '实际结束日期',
      dataIndex: 'actualEndDate',
      key: 'actualEndDate',
      width: 110,
    },
    {
      title: '入库时间',
      dataIndex: 'stockInDate',
      key: 'stockInDate',
      width: 110,
    },
    {
      title: '评估类',
      dataIndex: 'pglei',
      key: 'pglei',
      width: 60,
    },
  ];

  return (
    <>
      <ProTable
        options={false}
        search={false}
        actionRef={actionRef}
        request={async (pms: any) => {
          console.log(pms, 'pms');
          const sr = await queryPageByKanbanPenetrating({
            ...params,
            pageSize: pms.pageSize,
            current: pms.current,
          });
          // const sr = await queryPageByKanbanPenetrating({ ...params });
          sr.data.data.forEach((v, i) => (v.key = i + 1));
          const pageResult: Common.PageResult<any> = {
            current: pms.current,
            pageSize: pms.pageSize,
            total: sr.data.total,
            data: sr.data.data,
          };
          return pageResult;
        }}
        pagination={{
          pageSize: 10,
        }}
        columns={columns}
        size={'middle'}
        bordered
        scroll={{ x: 1100 }}
      />
    </>
  );
};

export default OrderModalTable;
