import React, { useEffect, useRef } from 'react';
import { queryMaterialReqOrderInfo } from '@/pages/kanban/productionComprehens/services/api';
import ProTable, { ActionType } from '@ant-design/pro-table';

type MaterialReqOrderInfoCriteria = KANBAN.ProductionComprehens.MaterialReqOrderInfoCriteria;

export type InfoProps = {
  values: MaterialReqOrderInfoCriteria;
};

const MaterialOrderModalTable: React.FC<InfoProps> = (props) => {
  const actionRef = useRef<ActionType>();
  useEffect(() => {
    actionRef.current?.reload();
  }, [props.values]);

  const columns = [
    {
      title: '单号',
      dataIndex: 'materialReqorderNo',
      key: 'materialReqorderNo',
    },
    {
      title: '需求日期',
      dataIndex: 'requiredDate',
      key: 'requiredDate',
    },
    {
      title: '配送地点',
      dataIndex: 'ltxa1',
      key: 'ltxa1',
    },
    {
      title: '创建时间',
      dataIndex: 'createdDate',
      key: 'createdDate',
    },
    {
      title: '物料编号',
      dataIndex: 'matnr',
      key: 'matnr',
    },
    {
      title: '物料描述',
      dataIndex: 'maktx',
      key: 'maktx',
    },
    {
      title: '库存地点',
      dataIndex: 'lgort',
      key: 'lgort',
    },
    {
      title: 'BOM定额',
      dataIndex: 'bomMenge',
      key: 'bomMenge',
    },
    {
      title: '计划数量',
      dataIndex: 'planMenge',
      key: 'planMenge',
    },
    {
      title: '过账总数量',
      dataIndex: 'totalMenge',
      key: 'totalMenge',
    },
    {
      title: '过账时间',
      dataIndex: 'executedDate',
      key: 'executedDate',
    },
  ];

  return (
    <>
      <ProTable
        options={false}
        search={false}
        actionRef={actionRef}
        request={async (params: MaterialReqOrderInfoCriteria) => {
          const sr = await queryMaterialReqOrderInfo({
            ...props.values,
            pageSize: params.pageSize,
            current: params.current,
          });
          const pageResult: Common.PageResult<any> = {
            current: params.current,
            pageSize: params.pageSize,
            total: sr.data.total,
            data: sr.data.data,
          };
          return pageResult;
        }}
        pagination={{
          pageSize: 10,
        }}
        columns={columns}
        size={'middle'}
        bordered
        scroll={{ x: 2000 }}
      />
    </>
  );
};

export default MaterialOrderModalTable;
