import ProTable, { ActionType } from '@ant-design/pro-table';
import React, { useEffect, useRef } from 'react';
import { queryPenetratingBatchInfo } from '../../services/api';

export type InfoProps = {
  values: {
    workUnitName: string;
  } & Common.PageParams;
};

const PartModalTable: React.FC<InfoProps> = (props) => {
  const actionRef = useRef<ActionType>();
  useEffect(() => {
    actionRef.current?.reload();
  }, [props.values]);

  const columns = [
    {
      title: '批号',
      dataIndex: 'lotNo',
      key: 'lotNo',
      width: 120,
    },
    {
      title: '生产订单',
      dataIndex: 'aufnr',
      key: 'aufnr',
      width: 120,
    },
    {
      title: '工厂',
      dataIndex: 'werks',
      key: 'werks',
      width: 120,
    },
    {
      title: '生产管理员',
      dataIndex: 'fevor',
      key: 'fevor',
      width: 120,
    },
    {
      title: '基本开始日期',
      dataIndex: 'gstrp',
      key: 'gstrp',
      width: 140,
    },
    {
      title: '基本结束日期',
      dataIndex: 'gltrp',
      key: 'gltrp',
      width: 140,
    },
    {
      title: '实际开始日期',
      dataIndex: 'actualStartDate',
      key: 'actualStartDate',
      width: 140,
    },
    {
      title: '实际结束日期',
      dataIndex: 'actualEndDate',
      key: 'actualEndDate',
      width: 140,
    },
    {
      title: '入库时间',
      dataIndex: 'stockInDate',
      key: 'stockInDate',
      width: 140,
    },
    {
      title: '评估类',
      dataIndex: 'pglei',
      key: 'pglei',
      width: 140,
    },
  ];

  return (
    <>
      <ProTable
        options={false}
        search={false}
        actionRef={actionRef}
        request={async (params) => {
          const sr = await queryPenetratingBatchInfo({
            ...props.values,
          });
          const pageResult = {
            total: sr.data.length,
            data: sr.data,
          };
          return pageResult;
        }}
        pagination={{
          pageSize: 10,
        }}
        columns={columns}
        size={'middle'}
        bordered
        scroll={{ x: 1400 }}
      />
    </>
  );
};

export default PartModalTable;
