import moment from 'moment';
import React, { useState, useEffect } from 'react';
import styles from './index.less';
import { delay, floor } from 'lodash';

export type Style1Props = {
  autoResize: boolean;
  headerText: string;
  subTitle?: string;
  onHeaderClick?: () => void;
};

const weekList = ['星期日', '星期一', '星期二', '星期三', '星期四', '星期五', '星期六'];
function getWeekDayString(weekDay: number) {
  return weekList[weekDay];
}

const Style1: React.FC<Style1Props> = ({
  autoResize,
  headerText,
  subTitle,
  children,
  onHeaderClick,
}) => {
  const [scaleWidth, setScaleWidth] = useState(1);
  const [scaleHeight, setScaleHeight] = useState(1);
  const [currentDate, setCurrentDate] = useState('');
  const [currentWeek, setCurrentWeek] = useState('');
  const [currentTime, setCurrentTime] = useState('');

  const resetScale = (ar: boolean) => {
    if (ar === true) {
      setScaleWidth(floor(document.body.clientWidth / 1920, 4));
      setScaleHeight(floor(document.body.clientHeight / 1080, 4));
      delay(
        () => {
          setScaleWidth(floor(document.body.clientWidth / 1920, 4));
          setScaleHeight(floor(document.body.clientHeight / 1080, 4));
        },
        1,
        20,
      );
    } else {
      setScaleWidth(1);
      setScaleHeight(1);
    }
  };

  useEffect(() => {
    document.body.onresize = () => resetScale(autoResize);
    resetScale(autoResize);
  }, [autoResize]);

  useEffect(() => {
    const t = setInterval(() => {
      const now = moment();
      setCurrentDate(now.format('YYYY.M.D'));
      setCurrentWeek(getWeekDayString(now.isoWeekday()));
      setCurrentTime(now.format('HH:mm:ss'));
    }, 1000);
    return () => {
      clearTimeout(t);
    };
  }, []);

  return (
    <>
      <div
        className={styles.container}
        style={{
          transform: `scale(${scaleWidth},${scaleHeight})`,
        }}
      >
        <div className={styles.header} onClick={() => onHeaderClick && onHeaderClick()}>
          <div className={styles.headercontent} onClick={() => {}}>
            <div className={styles.leftheader}>
              {currentDate}
              <br />
              {currentWeek} {currentTime}
            </div>
            <div className={styles.centerheader}>
              {headerText}
              <div className={styles.subTitle}>{subTitle}</div>
            </div>
            <div className={styles.rightheader}>
              <br />
            </div>
          </div>
        </div>
        <div className={styles.content}>{children}</div>
      </div>
    </>
  );
};

export default Style1;
