import './index.less';
import type { StatisTableDto } from '../../services/api';
import { useCallback, useEffect, useState } from 'react';
import type { Setting } from '../SettingForm';
import { Modal } from 'antd';
import QualityAbnormal from '@/pages/kanban/materialSynthesis/components/abnormal/qualityAbnormal';
import DeviceAbnormal from '@/pages/kanban/materialSynthesis/components/abnormal/deviceAbnormal';
import moment from 'moment';

type TableProps = {
  data: StatisTableDto;
  setting: Setting;
};

const CountTable: React.FC<TableProps> = ({ data, setting }) => {
  const [tableData, setTableData] = useState([]);
  const columns = [
    'dayShift',
    'middleShift',
    'nightShift',
    'dayOutput',
    'monthOutput',
    'qualityErrorCt',
    'equipmentErrorCt',
  ];
  const columnsName = ['白班', '中班', '夜班', '当日产量', '当月产量', '质量异常数', '设备异常数'];
  useEffect(() => {
    if (!data) return;
    const res = columns.map((v, i) => {
      const o = {
        device: columnsName[i],
        plan: data.plan[v],
        sum: data.workUnitAmount[v],
      };
      data.workUnitList.forEach((key, _) => (o[key] = data.workUnitDataList[_][v]));
      return o;
    });
    setTableData(res);
  }, [data]);

  const [isModalOpen, setIsModalOpen] = useState(false);
  const [modalType, setModalType] = useState(1);
  const [deviceParams, setDeviceParams] = useState({
    current: 1,
    pageSize: 10,
    workshopName: '',
    workUnitName: '',
    createdDateFrom: '',
    createdDateTo: '',
    status: '1,2,3',
  });
  const [qualityParams, setQualityParams] = useState({
    werks: '',
    fevor: '',
    workUnitName: '',
    createdDateFrom: '',
    createdDateTo: '',
    status: '1,2',
    current: 1,
    pageSize: 10,
  });
  const showModel = (i, key) => {
    if (i === 5) {
      setModalType(2);
      setQualityParams({
        ...qualityParams,
        werks: setting.QPProgressKanbanSetting?.werks,
        fevor:
          setting.QPProgressKanbanSetting?.qiPingProcessProgressStepList
            ?.filter((s) => s.typeId == 1)
            .map((s) => s.fevor)
            .join(',') || '',
        workUnitName: setting.QPProgressKanbanSetting?.qiPingDeviceProgressStepList.find(
          (s) => s.device == key,
        )?.operationUnit,
        createdDateFrom: moment()
          .date(1)
          .hour(0)
          .minute(0)
          .second(0)
          .millisecond(0)
          .format('YYYY-MM-DD HH:mm'),
        createdDateTo: moment().format('YYYY-MM-DD HH:mm'),
      });
      setIsModalOpen(true);
    } else if (i === 6) {
      setModalType(1);
      setDeviceParams({
        ...deviceParams,
        workshopName: setting.QPProgressKanbanSetting?.werks,
        workUnitName: setting.QPProgressKanbanSetting?.qiPingDeviceProgressStepList.find(
          (s) => s.device == key,
        )?.operationUnit,
        createdDateFrom: moment()
          .date(1)
          .hour(0)
          .minute(0)
          .second(0)
          .millisecond(0)
          .format('YYYY-MM-DD HH:mm'),
        createdDateTo: moment().format('YYYY-MM-DD HH:mm'),
      });
      setIsModalOpen(true);
    }
  };
  const closeModal = () => setIsModalOpen(false);

  return (
    <>
      <div className="main">
        <div className="table-header">
          <div className="fiexd-column" style={{ width: '140px' }}>
            <div className="table-cell">设备</div>
          </div>
          <div className="fiexd-column" style={{ width: '140px' }}>
            <div className="table-cell">计划</div>
          </div>
          <div className="fiexd-column" style={{ width: '140px' }}>
            <div className="table-cell">合计</div>
          </div>
          <div className="generate-column">
            {data?.workUnitList?.map((item) => (
              <div className="table-cell" key={item}>
                {item}
              </div>
            ))}
          </div>
        </div>

        <div className="table-body">
          {tableData.map((item, index) => (
            <div className="row-container" key={item.device}>
              <div className="flex-column" style={{ width: '140px' }}>
                <div className="table-b-cell">{item.device == null ? '/' : item.device}</div>
              </div>
              <div className="flex-column" style={{ width: '140px' }}>
                <div className="table-b-cell">{item.plan == null ? '/' : item.plan}</div>
              </div>
              <div className="flex-column" style={{ width: '140px' }}>
                <div className="table-b-cell">{item.sum == null ? '/' : item.sum}</div>
              </div>
              <div className="generate-column">
                {data.workUnitList.map((key) => (
                  <div className="table-b-cell" key={key} onClick={() => showModel(index, key)}>
                    {item[key] == null ? '/' : item[key]}
                  </div>
                ))}
              </div>
            </div>
          ))}
        </div>
      </div>

      <Modal
        title={modalType == 2 ? '质量异常明细' : '设备异常明细'}
        visible={isModalOpen}
        footer={null}
        width={'70%'}
        onCancel={closeModal}
      >
        {modalType == 2 ? (
          <QualityAbnormal values={qualityParams} />
        ) : (
          <DeviceAbnormal values={deviceParams} />
        )}
      </Modal>
    </>
  );
};

export default CountTable;
