// @ts-ignore
/* eslint-disable */

import { graphql } from '@/services/common';
import { request } from 'umi';

type ProductionProgressKanbanDataDto = KANBAN.ProductionProgress.ProductionProgressKanbanDataDto;
type ProductionProgressKanbanDataCriteria =
  KANBAN.ProductionProgress.ProductionProgressKanbanDataCriteria;
type ProductionProgressKanbanSetting = KANBAN.ProductionProgress.ProductionProgressKanbanSetting;

const productionProgressKanbanSettingGraphqlString =
  'query{productionProgressKanbanSetting{id,subTitle1,subTitle2,werks,fevor,overdueNone,overdueWarn,overdueSeverity,sgNoSourceType{id,code},progress{steps{code,ordinal,name}}}}';

export async function queryProductionProgressKanbanData(
  body: ProductionProgressKanbanDataCriteria,
  options?: { [key: string]: any },
) {
  return request<Api.ServiceResult<ProductionProgressKanbanDataDto[]>>(
    '/api/productionProgressKanban/data',
    {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      data: body,
      ...(options || {}),
    },
  );
}

export async function queryProductionProgressKanbanSetting() {
  const graphqlParams = {
    operationName: null,
    variables: {},
    query: productionProgressKanbanSettingGraphqlString,
  };
  return (await graphql(graphqlParams)).data
    .productionProgressKanbanSetting as ProductionProgressKanbanSetting[];
}

// 批次信息
export async function queryProductionProgressKanbanDetail(body: {
  kanbanSettingId: string;
  aufnr: string;
  processName: string;
}) {
  return request<
    Api.ServiceResult<{ lotNo: string; plannedEndDate: string; actualEndDate: string }[]>
  >('/productionProgressKanban/detail', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
  });
}
