import ProTable, { ActionType } from '@ant-design/pro-table';
import { useEffect, useRef } from 'react';
import { queryProductionProgressKanbanDetail } from '../../services/api';

const ProductionDetail: React.FC<{ params: any }> = ({ params }) => {
  const actionRef = useRef<ActionType>();
  useEffect(() => {
    actionRef.current?.reload();
  }, [params]);

  const columns = [
    {
      title: '批次号',
      dataIndex: 'lotNo',
      key: 'lotNos',
      width: 200,
    },
    {
      title: '计划完工时间',
      dataIndex: 'plannedEndDate',
      key: 'plannedEndDate',
    },
    {
      title: '实际完工时间',
      dataIndex: 'actualEndDate',
      key: 'actualEndDate',
    },
  ];

  return (
    <>
      <ProTable
        options={false}
        search={false}
        actionRef={actionRef}
        request={async () => {
          const sr = await queryProductionProgressKanbanDetail({ ...params });
          sr.data.forEach((item, i) => {
            item.key = i + 1;
          });
          return {
            data: sr.data,
            success: true,
          };
        }}
        pagination={false}
        columns={columns}
        size={'middle'}
        bordered
      />
    </>
  );
};

export default ProductionDetail;
