import React, { useRef } from 'react';
import type { ProFormInstance } from '@ant-design/pro-form';

import ProForm, { ProFormGroup, ProFormText } from '@ant-design/pro-form';
import serviceClient from '@/services/kanban/settings';
import { LockOutlined, UserOutlined } from '@ant-design/icons';
import styles from '@/pages/user/Login/index.less';
import { useIntl } from '@@/plugin-locale/localeExports';
import { message } from 'antd';
import { useModel } from '@@/plugin-model/useModel';
import { PageContainer } from '@ant-design/pro-layout';

export type CreateFormProps = {
  visible: boolean;
  onVisibleChange: (visible: boolean) => void;
  onSubmitting: () => Promise<any>;
  onSuccess: (params: any) => Promise<void>;
  onError: (params: any, error: unknown) => Promise<void>;
};

const CreateForm: React.FC<CreateFormProps> = (props) => {
  const { initialState } = useModel('@@initialState');
  const formRef = useRef<ProFormInstance>();
  const intl = useIntl();
  return (
    <PageContainer
      header={{
        title: null,
      }}
    >
      <ProForm
        formRef={formRef}
        title={'修改密码'}
        onFinish={async (value: { newPwd: string }) => {
          //const params = await props.onSubmitting();
          try {
            const formData = new FormData();
            formData.append('newPwd', value.newPwd as string);
            await serviceClient.updatePwdService.updatePwd(formData);
            message.success('密码修改成功');
            //await props.onSuccess(params);
          } catch (error) {
            message.error('密码修改失败');
            //await props.onError(params, error);
          }
        }}
      >
        <ProFormGroup>
          <ProFormText
            name="username"
            disabled={true}
            label={'用户名'}
            initialValue={initialState?.currentUser?.user?.nickName}
            fieldProps={{
              size: 'large',
              prefix: <UserOutlined className={styles.prefixIcon} />,
              placeholder: intl.formatMessage({
                id: 'pages.login.username.placeholder',
                defaultMessage: '用户名',
              }),
            }}
            rules={[
              {
                required: true,
                message: intl.formatMessage({
                  id: 'pages.login.username.required',
                  defaultMessage: '请输入用户名',
                }),
              },
            ]}
          />
          <ProFormText.Password
            name="newPwd"
            label={'密码'}
            fieldProps={{
              size: 'large',
              prefix: <LockOutlined className={styles.prefixIcon} />,
              placeholder: intl.formatMessage({
                id: 'pages.login.password.placeholder',
                defaultMessage: '密码',
              }),
            }}
            rules={[
              {
                required: true,
                message: intl.formatMessage({
                  id: 'pages.login.password.required',
                  defaultMessage: '请输入密码',
                }),
              },
            ]}
          />
        </ProFormGroup>
      </ProForm>
    </PageContainer>
  );
};

export default CreateForm;
