import React from 'react';
import { useIntl } from 'umi';
import { PageContainer } from '@ant-design/pro-layout';
import { Card, Alert } from 'antd';

const Welcome: React.FC = () => {
  const intl = useIntl();
  return (
    <PageContainer>
      <Card>
        <Alert
          message={intl.formatMessage({
            id: 'pages.welcome.speech',
            defaultMessage: '欢迎登陆看板系统',
          })}
          type="success"
          showIcon
          banner
          style={{
            margin: -12,
            marginBottom: 24,
          }}
        />
      </Card>
    </PageContainer>
  );
};

export default Welcome;
