﻿// key:'def...'表示默认路由，不需要后台返回

export default [
  {
    key: 'def1',
    path: '/user',
    layout: false,
    routes: [
      {
        path: '/user',
        routes: [
          {
            name: 'login',
            path: '/user/login',
            component: './user/Login',
          },
        ],
      },
      {
        component: './404',
      },
    ],
  },
  {
    key: 'def2',
    path: '/welcome',
    name: 'welcome',
    icon: 'smile',
    component: './Welcome',
  },
  {
    path: '/report',
    name: 'report',
    icon: 'BarChartOutlined',
    routes: [
      {
        path: 'reportOperation',
        name: 'reportOperation',
        component: './SimpleTable',
      },
      {
        path: 'reportOperationSetting',
        name: 'reportOperationSetting',
        component: 'report/settings/ReportOperationSetting',
      },
      {
        path: 'rptProductionByDay_GYQP',
        name: 'rptProductionByDay_GYQP',
        component: 'report/RptProductionByDay_GYQP',
      },
      {
        path: 'rptProductionByDay_QPZZ',
        name: 'rptProductionByDay_QPZZ',
        component: 'report/RptProductionByDay_QPZZ',
      },
      {
        path: 'rptProductionByDay_GRCC',
        name: 'rptProductionByDay_GRCC',
        component: 'report/RptProductionByDay_GRCC',
      },
      /*{
        path: 'rptProductionByDay_GRZZ',
        name: 'rptProductionByDay_GRZZ',
        component: 'report/RptProductionByDay_GRZZ',
      },*/
      {
        path: 'rptProductionByDay_DWP',
        name: 'rptProductionByDay_DWP',
        component: 'report/RptProductionByDay_DWP',
      },
      {
        path: 'rptProductionProgress_GYQP',
        name: 'rptProductionProgress_GYQP',
        component: 'report/RptProductionProgress_GYQP',
      },
      {
        path: 'rptProductionProgress_QPZZ',
        name: 'rptProductionProgress_QPZZ',
        component: 'report/RptProductionProgress_QPZZ',
      },
      {
        path: 'rptProductionProgress_GRCC',
        name: 'rptProductionProgress_GRCC',
        component: 'report/RptProductionProgress_GRCC',
      },
      {
        path: 'rptProductionProgress_DWP',
        name: 'rptProductionProgress_DWP',
        component: 'report/RptProductionProgress_DWP',
      },
    ],
  },
  {
    key: 'def4',
    path: '/kanban',
    name: 'kanban',
    icon: 'FundOutlined',
    routes: [
      // {
      //   path: 'productionProgressKanban',
      //   name: 'productionProgressKanban',
      //   target: '_blank',
      //   layout: false,
      //   component: './kanban/ProductionProgress',
      // },
      // {
      //   path: 'productProgressKanban',
      //   name: 'productProgressKanban',
      //   target: '_blank',
      //   layout: false,
      //   component: './kanban/ProductProgress',
      // },
      {
        path: 'productionComprehensKanban',
        name: 'productionComprehensKanban',
        target: '_blank',
        layout: false,
        component: './kanban/productionComprehens',
      },
      // {
      //   path: 'materialSynthesisKanban',
      //   name: 'materialSynthesisKanban',
      //   target: '_blank',
      //   layout: false,
      //   component: './kanban/materialSynthesis',
      // },
      // {
      //   path: 'weldingProcessKanban',
      //   name: 'weldingProcessKanban',
      //   target: '_blank',
      //   layout: false,
      //   component: './kanban/weldingProcessKanban',
      // },
      // {
      //   path: 'evacuationProcessKanban',
      //   name: 'evacuationProcessKanban',
      //   target: '_blank',
      //   layout: false,
      //   component: './kanban/evacuationProcessKanban',
      // },
      // {
      //   path: 'paintingProcessKanban',
      //   name: 'paintingProcessKanban',
      //   target: '_blank',
      //   layout: false,
      //   component: './kanban/paintingProcessKanban',
      // },
      // {
      //   path: 'airBottleProcessKanban',
      //   name: 'airBottleProcessKanban',
      //   target: '_blank',
      //   layout: false,
      //   component: './kanban/airBottleProcessKanban',
      // },
      // {
      //   path: 'qiPingComprehensKanban',
      //   name: 'qiPingComprehensKanban',
      //   target: '_blank',
      //   layout: false,
      //   component: './kanban/qipingComprehens',
      // },
      // {
      //   path: 'jiejingProduction',
      //   name: 'jiejingProduction',
      //   target: '_blank',
      //   layout: false,
      //   component: './kanban/workSiteProduction/Jiejing',
      // },
    ],
  },
  {
    path: '/kanbanData',
    name: 'kanbanData',
    icon: 'setting',
    routes: [
      {
        path: 'ProductionProgressKanban',
        name: 'ProductionProgressKanban',
        routes: [
          {
            path: 'ProductionProgressKanbanData1',
            name: 'ProductionProgressKanbanData1',
            component: './SimpleTable',
          },
          {
            path: 'ProductionProgressKanbanData2',
            name: 'ProductionProgressKanbanData2',
            component: './SimpleTable',
          },
        ],
      },
      {
        path: 'ProductProgressKanban',
        name: 'ProductProgressKanban',
        routes: [
          {
            path: 'ProductProgressKanbanData1',
            name: 'ProductProgressKanbanData1',
            component: './SimpleTable',
          },
          {
            path: 'ProductProgressKanbanData2',
            name: 'ProductProgressKanbanData2',
            component: './SimpleTable',
          },
        ],
      },
      {
        path: 'productionComprehensiveKanban',
        name: 'productionComprehensiveKanban',
        routes: [
          {
            path: 'workOrderMonthlyIndexData',
            name: 'workOrderMonthlyIndexData',
            component: './SimpleTable',
          },
          {
            path: 'processYieldStandDailyData',
            name: 'processYieldStandDailyData',
            component: './kanban/settings/ProcessYieldStandDailyData',
          },
          {
            path: 'processYieldData1',
            name: 'processYieldData1',
            component: './SimpleTable',
          },
          {
            path: 'processYieldData2',
            name: 'processYieldData2',
            component: './SimpleTable',
          },
          {
            path: 'processDefectRatioDatum',
            name: 'processDefectRatioDatum',
            component: './kanban/settings/ProcessDefectRatioDatum',
          },
          {
            path: 'processDefectRatioData',
            name: 'processDefectRatioData',
            component: './SimpleTable',
          },
          {
            path: 'hFChangedInfoData',
            name: 'hFChangedInfoData',
            component: './SimpleTable',
          },
          {
            path: 'hjBasicRate',
            name: 'hjBasicRate',
            component: './SimpleTable',
          },
        ],
      },
      {
        path: 'MaterialComprehensiveKanbanData',
        name: 'MaterialComprehensiveKanbanData',
        routes: [
          {
            path: 'materialReqOrder',
            name: 'materialReqOrder',
            component: './SimpleTable',
          },
          {
            path: 'MaterialComprehensiveKanbanData',
            name: 'MaterialComprehensiveKanbanData',
            component: './SimpleTable',
          },
          {
            path: 'partScheduleIndexData',
            name: 'partScheduleIndexData',
            component: './SimpleTable',
          },
        ],
      },
      {
        path: 'Error',
        name: 'Error',
        routes: [
          {
            path: 'productionIssue',
            name: 'productionIssue',
            component: './SimpleTable',
          },
          {
            path: 'productionIssueCancelled',
            name: 'productionIssueCancelled',
            component: './SimpleTable',
          },
          {
            path: 'qualityIssue',
            name: 'qualityIssue',
            component: './SimpleTable',
          },
          {
            path: 'qualityIssueCancelled',
            name: 'qualityIssueCancelled',
            component: './SimpleTable',
          },
          {
            path: 'equipmentIssue',
            name: 'equipmentIssue',
            component: './SimpleTable',
          },
          {
            path: 'equipmentIssueCancelled',
            name: 'equipmentIssueCancelled',
            component: './SimpleTable',
          },
        ],
      },
      {
        path: 'QiPingProcessKanban',
        name: 'QiPingProcessKanban',
        routes: [
          {
            path: 'qiPingDayNumber',
            name: 'qiPingDayNumber',
            component: './kanban/settings/QiPingDayNumber',
          },
          {
            path: 'qiPingProcessData',
            name: 'qiPingProcessData',
            component: './SimpleTable',
          },
        ],
      },
      {
        path: 'ChouKongProcessKanban',
        name: 'ChouKongProcessKanban',
        routes: [
          {
            path: 'chouKongProcessData',
            name: 'chouKongProcessData',
            component: './SimpleTable',
          },
        ],
      },
      {
        path: 'GaoYaProcessKanban',
        name: 'GaoYaProcessKanban',
        routes: [
          {
            path: 'gaoYaProcessData',
            name: 'gaoYaProcessData',
            component: './SimpleTable',
          },
          {
            path: 'gaoYaProcessStandardDailyData',
            name: 'gaoYaProcessStandardDailyData',
            component: './kanban/settings/GaoYaProcessStandardDailyData',
          },
        ],
      },
      {
        path: 'HjKanban',
        name: 'HjKanban',
        routes: [
          {
            path: 'hjKanbanData',
            name: 'hjKanbanData',
            component: './SimpleTable',
          },
        ],
      },
      {
        path: 'productionOrder',
        name: 'productionOrder',
        component: './SimpleTable',
      },
      {
        path: 'batchInfo',
        name: 'batchInfo',
        component: './SimpleTable',
      },
      {
        path: 'processReport',
        name: 'processReport',
        component: './SimpleTable',
      },
      {
        path: 'processBeginReport',
        name: 'processBeginReport',
        component: './SimpleTable',
      },
      {
        path: 'productionSchedule',
        name: 'productionSchedule',
        component: './SimpleTable',
      },
      {
        path: 'productionScheduleProcess',
        name: 'productionScheduleProcess',
        component: './SimpleTable',
      },
      {
        path: 'productionOrderCancel',
        name: 'productionOrderCancel',
        component: './SimpleTable',
      },
      {
        path: 'batchInfoCancel',
        name: 'batchInfoCancel',
        component: './SimpleTable',
      },
    ],
  },
  {
    path: '/kanbanSetting',
    name: 'kanbanSetting',
    icon: 'setting',
    routes: [
      {
        path: 'productionProgressSetting',
        name: 'productionProgressSetting',
        component: './kanban/settings/ProductionProgressSetting',
      },
      {
        path: 'productProgressSetting',
        name: 'productProgressSetting',
        component: './kanban/settings/ProductProgressSetting',
      },
      {
        path: 'materialComprehensiveSetting',
        name: 'materialComprehensiveSetting',
        component: './kanban/settings/MaterialComprehensiveSetting',
      },
      {
        path: 'productionComprehensiveKanbanSetting',
        name: 'productionComprehensiveKanbanSetting',
        component: './kanban/settings/ProductionComprehensiveKanbanSetting',
      },
      {
        path: 'hjKanbanSetting',
        name: 'hjKanbanSetting',
        component: './kanban/settings/HjKanbanSetting',
      },
      {
        path: 'qiPingProcessKanbanSetting',
        name: 'qiPingProcessKanbanSetting',
        component: './kanban/settings/QiPingProcessKanbanSetting',
      },
      {
        path: 'gaoYaProcessKanbanSetting',
        name: 'gaoYaProcessKanbanSetting',
        component: './kanban/settings/GaoYaProcessKanbanSetting',
      },
      {
        path: 'chouKongProcessKanbanSetting',
        name: 'chouKongProcessKanbanSetting',
        component: './kanban/settings/ChouKongProcessKanbanSetting',
      },
      {
        path: 'qiPingComprehensiveKanbanSetting',
        name: 'qiPingComprehensiveKanbanSetting',
        component: './kanban/settings/QiPingComprehensiveKanbanSetting',
      },
    ],
  },
  {
    path: '/systemSettings',
    name: 'systemSettings',
    icon: 'setting',
    routes: [
      {
        path: 'factorySetting',
        name: 'factorySetting',
        component: './SimpleTable',
      },
      {
        path: 'abnormalOverdueSetting',
        name: 'abnormalOverdueSetting',
        component: './SimpleTable',
      },
      {
        path: 'monthlyPlan',
        name: 'monthlyPlan',
        component: 'systemSettings/MonthlyPlan',
      },
      {
        path: 'deviceTotalQuantity',
        name: 'deviceTotalQuantity',
        component: 'systemSettings/DeviceTotalQuantity',
      },
      {
        path: 'pieceTotalQuantity',
        name: 'pieceTotalQuantity',
        component: './SimpleTable',
      },
    ],
  },
  {
    path: '/common',
    name: 'common',
    icon: 'setting',
    routes: [
      {
        path: 'singleTable',
        name: 'singleTable',
        component: './SimpleTable',
      },
      {
        path: 'singleTableField',
        name: 'singleTableField',
        component: './SimpleTable',
      },
      {
        path: 'entityMetadata',
        name: 'entityMetadata',
        component: './SimpleTable',
      },
      {
        path: 'entityPropertyMetadata',
        name: 'entityPropertyMetadata',
        component: './SimpleTable',
      },
      {
        component: './404',
      },
    ],
  },
  {
    key: 'def3',
    path: '/personalSetting',
    name: 'personalSetting',
    icon: 'user',
    routes: [
      {
        path: 'pwd',
        name: 'pwd',
        component: './common/Pwd',
        access: 'menuAccess',
      },
      {
        component: './404',
      },
    ],
  },
  {
    key: 'def44',
    path: '/',
    redirect: '/welcome',
  },
  {
    key: 'def5',
    component: './404',
  },
];
