package com.topsunit.scanservice.ximai.security;

import com.topsunit.scanservice.ximai.common.AppConfig;
import com.topsunit.scanservice.ximai.common.Constants;
import com.topsunit.scanservice.ximai.common.TopsunitException;
import com.topsunit.scanservice.ximai.dto.LoginResult;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * token验证处理
 *
 */
@Component
public class TokenService
{
    @Autowired
    AppConfig appConfig;


    /**
     * 获取用户身份信息
     *
     * @return 用户信息
     */
    public LoginResult getLoginUser(HttpServletRequest request)
    {
        LoginResult rst = new LoginResult();
        // 获取请求携带的令牌
        String token = getToken(request);
        if (StringUtils.isNotEmpty(token))
        {
            try
            {
                Claims claims = parseToken(token);
                // 解析对应的权限以及用户信息
                String uuid = (String) claims.get(Constants.LOGIN_USER_KEY);
                String userName = (String)claims.get(Constants.JWT_USERNAME);
                String userKey = getTokenKey(uuid);
                rst.setMv001(userName);
                rst.setMv002(userName);
                rst.setToken(token);
                return rst;
            }
            catch (Exception e)
            {
                throw new TopsunitException(e);
            }
        }
        return null;
    }


    /**
     * 从令牌中获取数据声明
     *
     * @param token 令牌
     * @return 数据声明
     */
    private Claims parseToken(String token)
    {
        return Jwts.parser()
                .setSigningKey(appConfig.getTokenSecret())
                .parseClaimsJws(token)
                .getBody();
    }

    /**
     * 从令牌中获取用户名
     *
     * @param token 令牌
     * @return 用户名
     */
    public String getUsernameFromToken(String token)
    {
        Claims claims = parseToken(token);
        return claims.getSubject();
    }

    /**
     * 获取请求token
     *
     * @param request
     * @return token
     */
    private String getToken(HttpServletRequest request)
    {
        String token = request.getHeader("Authorization");
        if (StringUtils.isNotEmpty(token) && token.startsWith(Constants.TOKEN_PREFIX))
        {
            token = token.replace(Constants.TOKEN_PREFIX, "");
        }
        return token;
    }

    private String getTokenKey(String uuid)
    {
        return Constants.LOGIN_TOKEN_KEY + uuid;
    }

    /**
     * 根据Token获取对应的用户
     * @param token
     * @return
     */
    public LoginResult getUserByToken(String token){
        LoginResult rst = new LoginResult();
        if (StringUtils.isNotEmpty(token))
        {
            try
            {
                Claims claims = parseToken(token);
                // 解析对应的权限以及用户信息
                String uuid = (String) claims.get(Constants.LOGIN_USER_KEY);
                String userName = (String)claims.get(Constants.JWT_USERNAME);
                String userKey = getTokenKey(uuid);
                rst.setMv001(userName);
                rst.setMv002(userName);
                rst.setToken(token);
                return rst;
            }
            catch (Exception e)
            {
                throw new TopsunitException(e);
            }
        }
        return null;
    }
}
