package com.topsunit.scanservice.ximai.entity.listeners;

import com.topsunit.scanservice.ximai.common.DateUtil;
import com.topsunit.scanservice.ximai.entity.Cmsmv;
import com.topsunit.scanservice.ximai.entity.EntityBase;
import com.topsunit.scanservice.ximai.security.CurrentActorSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import javax.persistence.*;

/**
 * <p>Title: EntityChangeListener</p>
 * <p>Description: 实体变更监听</p>
 *
 * @author xi.feng
 * @version V1.0
 * @date 2021/11/2
 */
public class EntityChangeListener implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(EntityChangeListener.class);
    private ApplicationContext applicationContext;
    private Cmsmv getCurrentActor(){
        return applicationContext.getBean(CurrentActorSetter.class).getActor();
    }
    private String getCompany(){
        return applicationContext.getBean(CurrentActorSetter.class).getCompany();
    }

    @PrePersist
    public void prePersist(Object object) {
        if(object instanceof EntityBase){
            EntityBase entity = (EntityBase) object;
            Cmsmv currentActor = getCurrentActor();
            String company = getCompany();
            entity.setCompany(company);
            if(currentActor!=null) {
                entity.setCreator(currentActor.getMv001());
                entity.setUsr_group(currentActor.getUsr_group());
            }
            entity.setCreateDate(DateUtil.currentDateTimeString());
            entity.setFlag(1);
        }
    }

    @PostPersist
    public void postPersist(Object object) {

    }

    @PreUpdate
    public void preUpdate(Object object) {
        if (object instanceof EntityBase) {
            EntityBase entity = (EntityBase) object;
            Cmsmv currentActor = getCurrentActor();
            if(currentActor!=null){
                entity.setModifier(currentActor.getMv001());
            }
            entity.setModiDate(DateUtil.currentDateTimeString());
            if (entity.getFlag() == null) {
                entity.setFlag(1);
            } else {
                entity.setFlag(entity.getFlag() + 1);
            }
        }
    }
    @PostUpdate
    public void postUpdate(Object object) {

    }

    @PreRemove
    public void preRemove(Object object) {

    }
    @PostRemove
    public void postRemove(Object object) {

    }
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
