package com.topsunit.scanservice.ximai.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * Author:   Jack
 * Date:     2021/10/28 22:35
 * Description: 领/退料单身Id
 */
public class MocteId implements Serializable {
    public MocteId() {
    }

    public MocteId(String te001, String te002, String te003) {
        this.te001 = String.format("%1$-4s", te001);
        this.te002 = String.format("%1$-11s", te002);
        this.te003 = String.format("%1$-4s", te003);
    }

    private String te001;
    private String te002;
    private String te003;

    public String getTe001() {
        return te001;
    }

    public void setTe001(String te001) {
        this.te001 = te001;
    }

    public String getTe002() {
        return te002;
    }

    public void setTe002(String te002) {
        this.te002 = te002;
    }

    public String getTe003() {
        return te003;
    }

    public void setTe003(String te003) {
        this.te003 = te003;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MocteId mocteId = (MocteId) o;
        return te001.equals(mocteId.te001) && te002.equals(mocteId.te002) && te003.equals(mocteId.te003);
    }

    @Override
    public int hashCode() {
        return Objects.hash(te001, te002, te003);
    }
}
