package com.topsunit.scanservice.ximai.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * Author:   Jack
 * Date:     2021/10/28 20:48
 * Description: 领/退料单头Id
 */
public class MoctcId implements Serializable {
    public MoctcId() {
    }

    public MoctcId(String tc001, String tc002) {
        this.tc001 = String.format("%1$-4s", tc001);
        this.tc002 = String.format("%1$-11s", tc002);
    }

    private String tc001;
    private String tc002;

    public String getTc001() {
        return tc001;
    }

    public void setTc001(String tc001) {
        this.tc001 = tc001;
    }

    public String getTc002() {
        return tc002;
    }

    public void setTc002(String tc002) {
        this.tc002 = tc002;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MoctcId moctcId = (MoctcId) o;
        return tc001.equals(moctcId.tc001) && tc002.equals(moctcId.tc002);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tc001, tc002);
    }
}
