package com.topsunit.scanservice.ximai.entity;

import java.io.Serializable;
import java.util.Objects;

/**
 * Author:   Jack
 * Date:     2021/10/29 21:43
 * Description: 品号仓库库位档Id
 */
public class InvmlId implements Serializable {

    public InvmlId() {
    }

    public InvmlId(String ml001, String ml002, String ml003, String ml004) {
        this.ml001 = String.format("%1$-20s", ml001);
        this.ml002 = String.format("%1$-10s", ml002);
        this.ml003 = String.format("%1$-10s", ml003);
        this.ml004 = String.format("%1$-20s", ml004);
    }

    private String ml001;
    private String ml002;
    private String ml003;
    private String ml004;

    public String getMl001() {
        return ml001;
    }

    public void setMl001(String ml001) {
        this.ml001 = ml001;
    }

    public String getMl002() {
        return ml002;
    }

    public void setMl002(String ml002) {
        this.ml002 = ml002;
    }

    public String getMl003() {
        return ml003;
    }

    public void setMl003(String ml003) {
        this.ml003 = ml003;
    }

    public String getMl004() {
        return ml004;
    }

    public void setMl004(String ml004) {
        this.ml004 = ml004;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InvmlId invmlId = (InvmlId) o;
        return ml001.equals(invmlId.ml001) && ml002.equals(invmlId.ml002) && ml003.equals(invmlId.ml003) && ml004.equals(invmlId.ml004);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ml001, ml002, ml003, ml004);
    }
}
