package com.topsunit.scanservice.ximai.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * Author:   Jack
 * Date:     2021/10/29 10:18
 * Description: 领/退料单身Dto
 */
@Data
public class MocteCreateDto {
    /*工艺*/
    @ApiModelProperty("工艺")
    private String tb006;
    /*材料品号*/
    @ApiModelProperty("材料品号")
    private String tb003;
    /*材料品名*/
    @ApiModelProperty("材料品名")
    private String tb012;
    /*需领用量*/
    @ApiModelProperty("需领用量")
    private BigDecimal tb004;
    /*已领用量*/
    @ApiModelProperty("已领用量")
    private BigDecimal tb005;
    /*仓库*/
    @ApiModelProperty("仓库")
    private String tb009;

    /*序号 0001流水*/
    @ApiModelProperty("序号")
    private String te003;
    /*批号 扫描，判断启用批号管理，使用INVML表判断是否存在*/
    @ApiModelProperty("批号 扫描，判断启用批号管理")
    private String te010;
    /*库位 默认库位，带出可修改*/
    @ApiModelProperty("库位 默认库位，带出可修改")
    private String te025;

    /**
     * 批管理 N=批管理
     */
    @ApiModelProperty("批管理 N:不需要、Y:需要不检查库存量、W:仅需警告、T:需要且检查库存量")
    private String mb022;

    private Boolean islot = false;

}
